/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.commands;

import ch.systemsx.cisd.common.collections.CollectionUtils;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.parser.IParserObjectFactory;
import ch.systemsx.cisd.common.parser.IParserObjectFactoryFactory;
import ch.systemsx.cisd.common.parser.IPropertyMapper;
import ch.systemsx.cisd.common.utilities.FileUtilities;
import ch.systemsx.cisd.common.utilities.SystemExit;
import ch.systemsx.cisd.lims.base.ILIMSService;
import ch.systemsx.cisd.lims.base.properties.PropertyType;
import ch.systemsx.cisd.lims.client.commands.AbstractCommandWithSessionToken;
import ch.systemsx.cisd.lims.client.commands.AbstractFileParameters;
import ch.systemsx.cisd.lims.client.commands.BisTabFileLoader;
import ch.systemsx.cisd.lims.client.commands.factory.PropertyTypeFactory;
import java.io.File;

public final class RegisterPropertyTypesCommand
extends AbstractCommandWithSessionToken {
    static final String NO_FILE_ERROR_MSG = "Exactly one file containing the property types you want to register must be specified.";
    private static final String NAME = "register-property-types";
    private static final String GENERIC_ARGS = "<property-types-file>";
    private static RegisterPropertyTypesCommand instance;

    private RegisterPropertyTypesCommand() {
        super(NAME);
    }

    public static final synchronized RegisterPropertyTypesCommand getInstance() {
        if (instance == null) {
            instance = new RegisterPropertyTypesCommand();
        }
        return instance;
    }

    private final void register(ILIMSService limsService, String sessionToken, PropertyType[] properties) {
        limsService.registerPropertyTypes(sessionToken, properties);
    }

    private final PropertyType[] loadProperties(File file) {
        BisTabFileLoader<PropertyType> tabFileLoader = new BisTabFileLoader<PropertyType>(new IParserObjectFactoryFactory<PropertyType>(){

            @Override
            public final IParserObjectFactory<PropertyType> createFactory(IPropertyMapper propertyMapper) {
                return PropertyTypeFactory.createInstance(propertyMapper);
            }
        });
        return tabFileLoader.load(file).toArray(PropertyType.EMPTY_ARRAY);
    }

    protected final int execute(String sessionToken, String[] arguments) throws UserFailureException, EnvironmentFailureException {
        Parameters parameters = new Parameters(arguments);
        ILIMSService limsService = this.getLIMSService(parameters);
        File file = parameters.getFile();
        String canonical = FileUtilities.getCanonicalPath(file);
        System.out.println(String.format("Registering property types from '%s'.", canonical));
        PropertyType[] properties = this.loadProperties(file);
        this.register(limsService, sessionToken, properties);
        System.out.println("  Following properties '" + CollectionUtils.abbreviate(properties, 5) + "' have been successfully registered.");
        return 0;
    }

    private final class Parameters
    extends AbstractFileParameters {
        Parameters(String[] args) {
            super(args, RegisterPropertyTypesCommand.this.getName(), RegisterPropertyTypesCommand.GENERIC_ARGS, SystemExit.SYSTEM_EXIT);
            if (this.getArgs().size() != 1) {
                System.err.println(RegisterPropertyTypesCommand.NO_FILE_ERROR_MSG);
                this.printHelp(true);
            }
        }
    }
}

