/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.commands;

import ch.systemsx.cisd.common.parser.IPropertiesSetter;
import ch.systemsx.cisd.common.parser.IPropertyObjectFactory;
import ch.systemsx.cisd.lims.base.NewSample;
import ch.systemsx.cisd.lims.base.SampleType;
import ch.systemsx.cisd.lims.base.properties.IEntityPropertiesSchema;
import ch.systemsx.cisd.lims.client.commands.AbstractPropertiesSetter;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SamplePropertiesSetter
extends AbstractPropertiesSetter<NewSample> {
    private static final String PARENT = "parent";
    private static final String CODE = "code";
    private static final String CONTROL_LAYOUT_HEADER = "control_layout";
    private final SampleType sampleType;
    private String controlLayoutCode;
    private String codeOfPlateToRegister;
    private String codeOfPlateToDeriveFrom;

    static IPropertyObjectFactory<NewSample> createFactory(final SampleType type, final IEntityPropertiesSchema schema) {
        return new IPropertyObjectFactory<NewSample>(){

            @Override
            public final IPropertiesSetter<NewSample> createObjectSetter() {
                return new SamplePropertiesSetter(type, schema, null);
            }
        };
    }

    private SamplePropertiesSetter(SampleType sampleType, IEntityPropertiesSchema schema) {
        super(schema);
        this.sampleType = sampleType;
    }

    @Override
    protected List<String> getMandatorySpecificColumns(boolean onlyMissing) {
        AbstractPropertiesSetter.ConditionalList<String> list = new AbstractPropertiesSetter.ConditionalList<String>(onlyMissing);
        list.add(CODE, this.codeOfPlateToRegister == null);
        list.add(PARENT, this.codeOfPlateToDeriveFrom == null);
        return list.toList();
    }

    @Override
    protected final NewSample createEntityPropertiesHolder() {
        NewSample sample = new NewSample();
        sample.setCode(this.codeOfPlateToRegister);
        sample.setGeneratedFrom(this.codeOfPlateToDeriveFrom);
        sample.setControlLayoutCode(this.controlLayoutCode);
        sample.setSampleTypeCode(this.sampleType.getCode());
        return sample;
    }

    @Override
    protected final boolean setSpecificProperty(String name, String valueOrNull) {
        boolean successful = true;
        if (name.equals(CONTROL_LAYOUT_HEADER)) {
            this.controlLayoutCode = valueOrNull;
        } else if (name.equals(CODE)) {
            this.codeOfPlateToRegister = valueOrNull;
        } else if (name.equals(PARENT)) {
            this.codeOfPlateToDeriveFrom = valueOrNull;
        } else {
            successful = false;
        }
        return successful;
    }

    /* synthetic */ SamplePropertiesSetter(SampleType sampleType, IEntityPropertiesSchema iEntityPropertiesSchema, SamplePropertiesSetter samplePropertiesSetter) {
        this(sampleType, iEntityPropertiesSchema);
    }
}

