/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.commands.factory;

import ch.systemsx.cisd.common.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.parser.AbstractParserObjectFactory;
import ch.systemsx.cisd.common.parser.IPropertyMapper;
import ch.systemsx.cisd.common.parser.ParserException;
import ch.systemsx.cisd.lims.base.ProcessingInstruction;
import ch.systemsx.cisd.lims.base.ProcessingParameters;
import ch.systemsx.cisd.lims.client.commands.factory.AbstractFileBasedConverter;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProcessingInstructionFactory
extends AbstractParserObjectFactory<ProcessingInstruction> {
    public static final String PROCESSING_DESCRIPTION_TEMPLATE = "Processing parameters from file '%s'.";

    private ProcessingInstructionFactory(IPropertyMapper propertyMapper, File rootDir) {
        super(ProcessingInstruction.class, propertyMapper);
        this.registerConverter(ProcessingParameters.class, new ProcessingParametersConverter(rootDir));
    }

    public static final ProcessingInstructionFactory createInstance(IPropertyMapper propertyMapper, File rootDir) {
        return new ProcessingInstructionFactory(propertyMapper, rootDir);
    }

    private final void checkProcessingInstruction(ProcessingInstruction instruction) {
        if (StringUtils.isEmpty(instruction.getPath())) {
            throw new ParserException("Missing processing code.");
        }
        ProcessingParameters parameters = instruction.getParameters();
        if (StringUtils.isBlank(instruction.getDescription()) && parameters != null) {
            instruction.setDescription(String.format(PROCESSING_DESCRIPTION_TEMPLATE, parameters.getFileName()));
        }
    }

    @Override
    public final ProcessingInstruction createObject(String[] lineTokens) throws ParserException {
        ProcessingInstruction instruction = (ProcessingInstruction)super.createObject(lineTokens);
        this.checkProcessingInstruction(instruction);
        return instruction;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProcessingParametersConverter
    extends AbstractFileBasedConverter<ProcessingParameters> {
        ProcessingParametersConverter(File rootDir) {
            super(rootDir);
        }

        @Override
        protected final ProcessingParameters convert(File file) {
            try {
                byte[] content = FileUtils.readFileToByteArray((File)file);
                ProcessingParameters parameters = ProcessingParameters.tryToCreateFromBinary(content);
                parameters.setFileName(file.getAbsolutePath());
                return parameters;
            }
            catch (IOException ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary(ex);
            }
        }

        @Override
        public final ProcessingParameters getDefaultValue() {
            return null;
        }
    }
}

