/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.commands.factory;

import ch.systemsx.cisd.common.parser.AbstractParserObjectFactory;
import ch.systemsx.cisd.common.parser.IPropertyMapper;
import ch.systemsx.cisd.common.parser.ParserException;
import ch.systemsx.cisd.lims.base.properties.EntityDataType;
import ch.systemsx.cisd.lims.base.properties.PropertyType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyTypeFactory
extends AbstractParserObjectFactory<PropertyType> {
    private PropertyTypeFactory(IPropertyMapper propertyMapper) {
        super(PropertyType.class, propertyMapper);
    }

    public static final PropertyTypeFactory createInstance(IPropertyMapper propertyMapper) {
        return new PropertyTypeFactory(propertyMapper);
    }

    private final void ensureValid(PropertyType property) {
        EntityDataType dataType = this.ensureDataTypeValid(property);
        this.ensureVocabularyCodeValid(property, dataType);
    }

    private final void ensureVocabularyCodeValid(PropertyType property, EntityDataType dataType) {
        String vocabularyCode = property.getVocabularyCode();
        String propertyName = property.getCode();
        String vocabularyTypeUserCode = EntityDataType.VOCABULARY.createSimple();
        if (dataType == EntityDataType.VOCABULARY) {
            if (vocabularyCode == null) {
                throw new ParserException(String.format("The vocabulary code is not specified for the property '%s', although it has %s type.", propertyName, vocabularyTypeUserCode));
            }
        } else if (vocabularyCode != null) {
            throw new ParserException(String.format("The vocabulary code must not be specified for the property '%s', because the property type is not '%s'.", propertyName, vocabularyTypeUserCode));
        }
    }

    private final EntityDataType ensureDataTypeValid(PropertyType property) {
        String dataTypeCode = property.getType();
        try {
            return EntityDataType.createFromSimple(dataTypeCode);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParserException(String.format("Given data type code '%s' is unknown.", dataTypeCode));
        }
    }

    @Override
    public final PropertyType createObject(String[] lineTokens) throws ParserException {
        PropertyType property = (PropertyType)super.createObject(lineTokens);
        this.ensureValid(property);
        return property;
    }
}

