/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.model;

import ch.systemsx.cisd.lims.base.FieldName;
import ch.systemsx.cisd.lims.base.Person;
import ch.systemsx.cisd.lims.base.properties.PropertyType;
import ch.systemsx.cisd.lims.client.model.ModalTableModel;
import ch.systemsx.cisd.lims.client.model.PropertiesDescriptor;
import java.util.Arrays;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyTypeTableModel
extends ModalTableModel {
    private final PropertyType[] propertyTypes;

    public PropertyTypeTableModel(PropertyType[] propertyTypes, boolean prettyMode) {
        super(prettyMode);
        this.propertyTypes = propertyTypes;
        Arrays.sort(propertyTypes);
    }

    @Override
    public final Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 3: {
                return Person.class;
            }
            case 4: {
                return Date.class;
            }
        }
        return String.class;
    }

    @Override
    public final String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return FieldName.CODE.getName(this.prettyMode);
            }
            case 1: {
                return FieldName.LABEL.getName(this.prettyMode);
            }
            case 2: {
                return FieldName.DATA_TYPE.getName(this.prettyMode);
            }
            case 3: {
                return FieldName.REGISTRATOR.getName(this.prettyMode);
            }
            case 4: {
                return FieldName.REGISTRATION_DATE.getName(this.prettyMode);
            }
        }
        throw new IllegalArgumentException("columnIndex '" + columnIndex + "' not allowed.");
    }

    @Override
    public final int getColumnCount() {
        return 5;
    }

    @Override
    public final String getHeader() {
        return "Property Types";
    }

    @Override
    public final int getRowCount() {
        return this.propertyTypes.length;
    }

    @Override
    public final Object getValueAt(int rowIndex, int columnIndex) {
        PropertyType property = this.propertyTypes[rowIndex];
        switch (columnIndex) {
            case 0: {
                return property.getCode();
            }
            case 1: {
                return property.getUserLabel();
            }
            case 2: {
                return PropertiesDescriptor.getTypeDescription(property);
            }
            case 3: {
                return property.getRegistrator();
            }
            case 4: {
                return property.getRegistrationDate();
            }
        }
        throw new IllegalArgumentException("columnIndex '" + columnIndex + "' not allowed.");
    }
}

