/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.output;

import ch.systemsx.cisd.common.io.ILinePrinter;
import ch.systemsx.cisd.lims.client.output.IOutputPrinter;
import ch.systemsx.cisd.lims.client.table.ASCIITable;
import ch.systemsx.cisd.lims.client.table.ITableModel;
import java.util.List;
import org.apache.commons.lang.StringUtils;

class PrettyOutputPrinter
implements IOutputPrinter {
    private final ILinePrinter printer;
    private final String templateForFirstKeyValuePair;
    private boolean firstKeyValuePair = true;

    PrettyOutputPrinter(ILinePrinter printer, String templateForFirstKeyValuePair) {
        assert (printer != null) : "Unspecified line printer.";
        assert (templateForFirstKeyValuePair != null) : "Unspecified template.";
        this.printer = printer;
        this.templateForFirstKeyValuePair = templateForFirstKeyValuePair;
    }

    public void printKeyValuePair(String key, String valueOrNull) {
        if (this.firstKeyValuePair) {
            this.printer.println(String.format(this.templateForFirstKeyValuePair, key.toLowerCase(), valueOrNull));
            this.firstKeyValuePair = false;
        } else {
            this.printer.println("  " + key + ": " + StringUtils.defaultIfEmpty(valueOrNull, "-"));
        }
    }

    public void printTableModel(ITableModel tableModel, String tableComment) {
        ASCIITable table = new ASCIITable(tableModel, tableComment);
        List<String> lines = table.printTable();
        for (String line : lines) {
            this.printer.println(line);
        }
    }
}

