/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.parameters;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.utilities.IExitHandler;
import ch.systemsx.cisd.common.utilities.OSUtilities;
import ch.systemsx.cisd.common.utilities.SystemExit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.ExampleMode;
import org.kohsuke.args4j.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractParameters {
    private static final String OPENBIS_WINDOWS_COMMAND_PREPEND = "bis ";
    private static final String OPENBIS_UNIX_COMMAND_PREPEND = "bis.sh ";
    @Option(name="s", longName="server-base-url", metaVar="URL", usage="Base URL of the server")
    private String baseURL;
    @Argument
    private final List<String> args = new ArrayList<String>();
    private final CmdLineParser parser = new CmdLineParser((Object)this);
    private final IExitHandler exitHandler;
    private final String programCall;
    private final String genericArgs;

    public AbstractParameters(String[] args, String limsCommandName) {
        this(args, limsCommandName, "");
    }

    public AbstractParameters(String[] args, String limsCommandName, String genericArgs) {
        this(args, limsCommandName, genericArgs, SystemExit.SYSTEM_EXIT);
    }

    public AbstractParameters(String[] args, String limsCommandName, String genericArgs, IExitHandler exitHandler) {
        this.exitHandler = exitHandler;
        this.programCall = String.valueOf(AbstractParameters.getCommandPrepender()) + limsCommandName;
        this.genericArgs = genericArgs;
        try {
            this.parser.parseArgument(args);
        }
        catch (CmdLineException ex) {
            throw new UserFailureException(ex.getMessage(), ex);
        }
    }

    public static String getCommandPrepender() {
        if (OSUtilities.isUnix()) {
            return OPENBIS_UNIX_COMMAND_PREPEND;
        }
        return OPENBIS_WINDOWS_COMMAND_PREPEND;
    }

    @Option(name="h", longName="help", usage="Show this help text", skipForExample=true)
    public void printHelp(boolean exit) {
        this.parser.printHelp(this.programCall, "[option [...]]", this.genericArgs, ExampleMode.ALL);
        if (exit) {
            this.exitHandler.exit(0);
        }
    }

    public final String getBaseURL() {
        return this.baseURL;
    }

    public final List<String> getArgs() {
        return Collections.unmodifiableList(this.args);
    }
}

