/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.utilities;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.utilities.DateTimeUtils;
import ch.systemsx.cisd.common.utilities.FileUtilities;
import ch.systemsx.cisd.lims.base.MaterialCriteria;
import ch.systemsx.cisd.lims.base.QueryRestriction;
import ch.systemsx.cisd.lims.base.TimeInterval;
import ch.systemsx.cisd.lims.client.utilities.Constants;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.time.DateFormatUtils;

public final class Utilities {
    private static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    static final String PREFIX = "now";

    private Utilities() {
    }

    public static String tryCheckAndGetSessionToken() {
        if (Constants.SESSION_TOKEN_FILE.exists()) {
            return FileUtilities.loadToString(Constants.SESSION_TOKEN_FILE).trim();
        }
        System.err.println("You are not logged in. Please use the login command to log in first.");
        return null;
    }

    public static File getFileCheckAccesible(String filePath) {
        File file = new File(filePath);
        Utilities.checkAccessible(file);
        return file;
    }

    public static void checkAccessible(File file) throws UserFailureException {
        FileInputStream stream = null;
        try {
            try {
                stream = FileUtils.openInputStream((File)file);
            }
            catch (IOException ex) {
                throw new UserFailureException(ex.getMessage());
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
    }

    public static final String formatDate(Date date) {
        assert (date != null) : "Unspecified date.";
        return String.valueOf(DateFormatUtils.format(date, DEFAULT_DATE_FORMAT)) + " " + DateTimeUtils.getTimeZone(date);
    }

    public static TimeInterval parseTimeInterval(String timeIntervalDescriptionOrNull) {
        Date from = null;
        Date until = null;
        if (timeIntervalDescriptionOrNull != null && timeIntervalDescriptionOrNull.length() > 0) {
            int colonIndex = timeIntervalDescriptionOrNull.indexOf(58);
            if (colonIndex < 0) {
                throw new UserFailureException("Missing ':' in '" + timeIntervalDescriptionOrNull + "'.");
            }
            from = Utilities.parseTime(timeIntervalDescriptionOrNull.substring(0, colonIndex));
            until = Utilities.parseTime(timeIntervalDescriptionOrNull.substring(colonIndex + 1));
        }
        try {
            return new TimeInterval(from, until);
        }
        catch (IllegalArgumentException e) {
            throw new UserFailureException(e.getMessage());
        }
    }

    private static Date parseTime(String timeDescription) {
        if (timeDescription.length() == 0) {
            return null;
        }
        if (timeDescription.equals(PREFIX)) {
            return new Date();
        }
        if (timeDescription.startsWith(PREFIX)) {
            int lastIndex = timeDescription.length() - 1;
            TimeUnit unit = TimeUnit.resolveFromSymbol(timeDescription.charAt(lastIndex));
            try {
                int value = Integer.parseInt(timeDescription.substring(PREFIX.length(), lastIndex));
                return unit.calculateTimeStamp(value);
            }
            catch (NumberFormatException numberFormatException) {
                throw new UserFailureException("Invalid time description: " + timeDescription);
            }
        }
        try {
            return DATE_FORMAT.parse(timeDescription);
        }
        catch (ParseException parseException) {
            throw new UserFailureException("Invalid time description: " + timeDescription);
        }
    }

    public static final String createMessageInfoSnippet(QueryRestriction queryRestriction) {
        TimeInterval timeInterval;
        MaterialCriteria materialCriteria;
        ArrayList<String> items = new ArrayList<String>();
        String projectCode = queryRestriction.getProjectCode();
        String experimentTypeCode = queryRestriction.getExperimentTypeCode();
        if (experimentTypeCode != null) {
            items.add("experiment type '" + experimentTypeCode + "'");
        }
        if (projectCode != null) {
            items.add("project '" + projectCode + "'");
        }
        if ((materialCriteria = queryRestriction.getMaterialCriteria()) != null) {
            String studyObjectCode = materialCriteria.getCode();
            assert (studyObjectCode != null) : "If we have a material criteria, we must have at least the study object code.";
            items.add("study object '" + studyObjectCode + "'");
        }
        if ((timeInterval = queryRestriction.getTimeInterval()) != null && (timeInterval.getFrom() != null || timeInterval.getUntil() != null)) {
            String item = "time interval";
            Date from = timeInterval.getFrom();
            if (from != null) {
                item = String.valueOf(item) + " from " + DATE_FORMAT.format(from);
            }
            item = String.valueOf(item) + " until ";
            Date until = timeInterval.getUntil();
            item = String.valueOf(item) + (until == null ? PREFIX : DATE_FORMAT.format(until));
            items.add(item);
        }
        StringBuilder builder = new StringBuilder();
        int numberOfItems = items.size();
        int i = 0;
        while (i < numberOfItems) {
            if (i == 0) {
                builder.append(" for ");
            } else if (i < numberOfItems - 1) {
                builder.append(", ");
            } else {
                builder.append(numberOfItems > 3 ? ", and " : " and ");
            }
            builder.append((String)items.get(i));
            ++i;
        }
        return builder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TimeUnit {
        HOUR("h", 3600000L),
        DAY("d", 86400000L),
        WEEK("w", 604800000L),
        MONTH("m", 2592000000L),
        YEAR("y", 31536000000L);

        private final String symbol;
        private final long milliseconds;

        static TimeUnit resolveFromSymbol(char symbol) {
            TimeUnit[] units;
            String symbolString = Character.toString(symbol);
            TimeUnit[] timeUnitArray = units = TimeUnit.values();
            int n = units.length;
            int n2 = 0;
            while (n2 < n) {
                TimeUnit unit = timeUnitArray[n2];
                if (unit.symbol.equals(symbolString)) {
                    return unit;
                }
                ++n2;
            }
            throw new UserFailureException("Unknown time interval unit '" + symbol + "'.");
        }

        private TimeUnit(String symbol, long milliseconds) {
            this.symbol = symbol;
            this.milliseconds = milliseconds;
        }

        Date calculateTimeStamp(int value) {
            return new Date(System.currentTimeMillis() + (long)value * this.milliseconds);
        }
    }
}

