/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.logging.LogInitializer;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public final class OpenBISServer {
    private OpenBISServer() {
    }

    private static final File getWebInfDirectory() {
        File webInf = new File("targets/WEB-INF");
        if (!webInf.exists()) {
            if (!webInf.mkdir()) {
                throw EnvironmentFailureException.fromTemplate("Was not able to create directory '%s'.", webInf.getAbsolutePath());
            }
        } else if (!webInf.isDirectory()) {
            throw UserFailureException.fromTemplate("Given path '%s' is not a directory.", webInf.getAbsolutePath());
        }
        return webInf;
    }

    private static final File getSpringServletXml() {
        File springServletXml = new File("resource/server/spring-servlet.xml");
        if (!springServletXml.isFile()) {
            throw UserFailureException.fromTemplate("Given path '%s' is not a file.", springServletXml.getAbsolutePath());
        }
        return springServletXml;
    }

    public static void main(String[] args) throws Exception {
        LogInitializer.init();
        File webInf = OpenBISServer.getWebInfDirectory();
        File springServlet = OpenBISServer.getSpringServletXml();
        FileUtils.copyFileToDirectory((File)springServlet, (File)webInf);
        new FileSystemXmlApplicationContext("classpath:jetty.xml");
    }
}

