/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.business;

import ch.systemsx.cisd.common.exceptions.InternalErr;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.utilities.BeanUtils;
import ch.systemsx.cisd.lims.base.EntityPropertyFiller;
import ch.systemsx.cisd.lims.base.EntityTypeMandatorilyRelation;
import ch.systemsx.cisd.lims.base.PropertyTypeEntityTypeRelation;
import ch.systemsx.cisd.lims.base.properties.EntityKind;
import ch.systemsx.cisd.lims.base.properties.EntityPropertySchema;
import ch.systemsx.cisd.lims.base.properties.PropertyType;
import ch.systemsx.cisd.lims.base.properties.SimpleEntityPropertySchema;
import ch.systemsx.cisd.lims.server.business.AbstractManager;
import ch.systemsx.cisd.lims.server.business.BeanUtilsConverters;
import ch.systemsx.cisd.lims.server.business.IEntityPropertyManager;
import ch.systemsx.cisd.lims.server.business.ParameterChecker;
import ch.systemsx.cisd.lims.server.business.Session;
import ch.systemsx.cisd.lims.server.business.StrategyFactoryProvider;
import ch.systemsx.cisd.lims.server.business.bo.IBusinessObjectFactory;
import ch.systemsx.cisd.lims.server.business.bo.IEntityPropertiesBO;
import ch.systemsx.cisd.lims.server.business.bo.IEntityPropertyTypeTable;
import ch.systemsx.cisd.lims.server.business.bo.IKey;
import ch.systemsx.cisd.lims.server.business.bo.IPropertyTypeTable;
import ch.systemsx.cisd.lims.server.business.bo.PropertyTypeAssignmentStatus;
import ch.systemsx.cisd.lims.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.lims.server.dataaccess.IEntityPropertyTypeDAO;
import ch.systemsx.cisd.lims.server.dataaccess.IEntityTypeDAO;
import ch.systemsx.cisd.lims.server.dto.EntityPropertyTypeAssignmentDTO;
import ch.systemsx.cisd.lims.server.dto.EntityTypeDTO;
import ch.systemsx.cisd.lims.server.dto.PropertyTypeDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.transaction.annotation.Transactional;

final class EntityPropertyManager
extends AbstractManager
implements IEntityPropertyManager {
    public EntityPropertyManager(IDAOFactory daoFactory, StrategyFactoryProvider strategyProvider, IBusinessObjectFactory boFactory) {
        super(daoFactory, strategyProvider, boFactory);
    }

    private String translateUserMessage(PropertyTypeAssignmentStatus status, EntityKind entityKind, String entityTypeCode, String propertyTypeCode, boolean mandatory, EntityPropertyFiller[] propertyFillers) {
        String template;
        String mandatoryDesc = mandatory ? "mandatory" : "optional";
        String capitalizedMandatoryDesc = StringUtils.capitalize(mandatoryDesc);
        boolean error = false;
        if (status.equals((Object)PropertyTypeAssignmentStatus.INTERNALLY_MANAGED_ASSIGNMENT_UPDATE_ERROR)) {
            template = "It is not possible to change the assignment of property '%s' to the %s type '%s' because the assignment is managed internally.";
            error = true;
        } else if (status.equals((Object)PropertyTypeAssignmentStatus.INTERNALLY_MANAGED_PROPERTY_TYPE_ERROR)) {
            template = "Assignment of property '%s' to the %s type '%s' is not possible because the property type is managed internally.";
            error = true;
        } else if (status.equals((Object)PropertyTypeAssignmentStatus.PROPERTY_ASSIGNED)) {
            template = String.valueOf(capitalizedMandatoryDesc) + " property '%s' successfully assigned to the %s type '%s'.";
        } else if (status.equals((Object)PropertyTypeAssignmentStatus.EXACTLY_SAME_ASSIGNMENT_EXISTS)) {
            template = String.valueOf(capitalizedMandatoryDesc) + " property '%s' was already assigned to the %s type '%s'. Assignment has not changed.";
        } else if (status.equals((Object)PropertyTypeAssignmentStatus.MANDATORY_FLAG_CHANGED)) {
            template = "Assignment of the property '%s' to the %s type '%s' has been changed. The property is now " + mandatoryDesc + ".";
        } else {
            throw InternalErr.error();
        }
        if (!error && propertyFillers.length > 0) {
            template = String.valueOf(template) + " Property values for given entities have been set.";
        }
        return String.format("  " + template, propertyTypeCode, entityKind.getLabel(), entityTypeCode);
    }

    private void assertNoMissingEntitiesAndNoUnmatchedValues(IEntityPropertiesBO entityPropertiesBO, boolean mandatory) {
        Set<IKey> unmatchedValues;
        Set<IKey> missingEntities = entityPropertiesBO.getMissingEntities();
        StringBuilder builder = new StringBuilder();
        if (mandatory && missingEntities.size() > 0) {
            builder.append("Property cannot become mandatory, because property values for following codes are missing:\n");
            for (IKey key : missingEntities) {
                builder.append(key.getUniqueDescription());
                builder.append("\n");
            }
        }
        if ((unmatchedValues = entityPropertiesBO.getUnmatchedValues()).size() > 0) {
            builder.append("The following codes do not exist or their property values have already been set:\n");
            for (IKey entityPropertyFiller : unmatchedValues) {
                builder.append(entityPropertyFiller.getUniqueDescription());
                builder.append("\n");
            }
        }
        if (builder.length() > 0) {
            throw new UserFailureException(builder.toString());
        }
    }

    private final long getPropertyTypeId(String propertyName) {
        Long id = this.daoFactory.getPropertyTypeDAO().tryFindPropertyTypeIdByCode(propertyName);
        if (id == null) {
            throw UserFailureException.fromTemplate("Property type with the name '%s' does not exist!", propertyName);
        }
        return id;
    }

    private final long getEntityTypeId(EntityKind entityKind, String entityTypeCode) {
        IEntityTypeDAO entityTypeDAO = this.daoFactory.getEntityTypeDAO(entityKind);
        EntityTypeDTO entityType = entityTypeDAO.tryToFindEntityTypeByCode(entityTypeCode);
        if (entityType == null) {
            throw UserFailureException.fromTemplate("Invalid %s type code '%s'. It does not exist!", entityKind.getLabel(), entityTypeCode);
        }
        return entityType.getId();
    }

    @Transactional
    public final PropertyType[] listPropertyTypes(Session session) throws UserFailureException {
        IPropertyTypeTable propertyTypeTable = this.boFactory.createPropertyTypeTable(session);
        propertyTypeTable.load();
        propertyTypeTable.enrichWithRegistrator();
        return BeanUtils.createBeanList(PropertyType.class, propertyTypeTable, BeanUtilsConverters.getPropertyTypeConverter()).toArray(PropertyType.EMPTY_ARRAY);
    }

    @Transactional
    public final SimpleEntityPropertySchema[] listPropertyTypes(EntityKind entityKind, String entityTypeCode) throws UserFailureException {
        long entityTypeId = this.getEntityTypeId(entityKind, entityTypeCode);
        List<EntityPropertySchema> schema = this.daoFactory.getEntityPropertyTypeDAO(entityKind).listEntityPropertyTypes(entityTypeId);
        ArrayList<SimpleEntityPropertySchema> result = new ArrayList<SimpleEntityPropertySchema>();
        for (EntityPropertySchema propertyType : schema) {
            result.add(propertyType.createSimple());
        }
        return result.toArray(new SimpleEntityPropertySchema[result.size()]);
    }

    @Transactional
    public final PropertyTypeEntityTypeRelation[] listPropertyTypeEntityTypeRelations(Session session, EntityKind entityKind) throws UserFailureException {
        IPropertyTypeTable propertyTypeTable = this.boFactory.createPropertyTypeTable(session);
        propertyTypeTable.load();
        propertyTypeTable.enrichWithRegistrator();
        ArrayList<PropertyTypeEntityTypeRelation> result = new ArrayList<PropertyTypeEntityTypeRelation>();
        for (PropertyTypeDTO propertyTypeDTO : propertyTypeTable) {
            PropertyTypeEntityTypeRelation relation = new PropertyTypeEntityTypeRelation();
            PropertyType propertType = BeanUtils.createBean(PropertyType.class, propertyTypeDTO, BeanUtilsConverters.getPropertyTypeConverter());
            relation.setProperty(propertType);
            result.add(relation);
        }
        IEntityPropertyTypeTable relationTable = this.boFactory.createEntityPropertyTypeTable(session);
        relationTable.loadRelations(entityKind);
        for (PropertyTypeEntityTypeRelation relation : result) {
            List<EntityPropertyTypeAssignmentDTO> list = relationTable.getRelationsFor(relation.getProperty().getCode());
            if (list == null) continue;
            List<EntityTypeMandatorilyRelation> translatedlist = BeanUtils.createBeanList(EntityTypeMandatorilyRelation.class, list);
            relation.setRelations(translatedlist.toArray(new EntityTypeMandatorilyRelation[0]));
        }
        return result.toArray(new PropertyTypeEntityTypeRelation[result.size()]);
    }

    @Transactional
    public final String assignPropertyType(Session session, EntityKind entityKind, String entityTypeCode, String propertyTypeCode, boolean mandatory, EntityPropertyFiller[] propertyFillers, String globalValueOrNull) throws UserFailureException {
        ParameterChecker.checkIfNotNull(propertyTypeCode, "property type code");
        ParameterChecker.checkIfNotNull(entityTypeCode, "entity type code");
        ParameterChecker.checkIfNotNull(propertyFillers, "entity property fillers");
        IEntityPropertiesBO entityPropertiesBO = this.boFactory.createEntityPropertiesBO(entityKind, session);
        entityPropertiesBO.createAssignmentAndPropertyValues(entityTypeCode, propertyTypeCode, mandatory, globalValueOrNull, propertyFillers);
        this.assertNoMissingEntitiesAndNoUnmatchedValues(entityPropertiesBO, mandatory);
        PropertyTypeAssignmentStatus status = entityPropertiesBO.getAssignmentStatus();
        return this.translateUserMessage(status, entityKind, entityTypeCode, propertyTypeCode, mandatory, propertyFillers);
    }

    @Transactional
    public final void unassignPropertyType(Session session, EntityKind entityKind, String propertyTypeCode, String entityTypeCode) throws UserFailureException {
        ParameterChecker.checkIfNotNull(propertyTypeCode, "property type code");
        ParameterChecker.checkIfNotNull(entityTypeCode, "entity type code");
        long entityTypeId = this.getEntityTypeId(entityKind, entityTypeCode);
        long propertyTypeId = this.getPropertyTypeId(propertyTypeCode);
        IEntityPropertyTypeDAO entityPropertyTypeDAO = this.daoFactory.getEntityPropertyTypeDAO(entityKind);
        EntityPropertyTypeAssignmentDTO assignment = entityPropertyTypeDAO.tryFindAssignment(entityTypeId, propertyTypeId);
        if (assignment != null) {
            if (assignment.isManagedInternally()) {
                throw new UserFailureException("Internally managed property '" + propertyTypeCode + "' for " + entityKind.getLabel() + " of type '" + entityTypeCode + "' can not be unassigned.");
            }
        } else {
            throw new UserFailureException("Property '" + propertyTypeCode + "' is not assigned to " + entityKind.getLabel() + " of type '" + entityTypeCode + "', so cannot be unassigned.");
        }
        entityPropertyTypeDAO.unassignEntityPropertyType(entityTypeId, propertyTypeId);
    }
}

