/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.business;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.utilities.BeanUtils;
import ch.systemsx.cisd.lims.base.BaseExperiment;
import ch.systemsx.cisd.lims.base.ExperimentFileAttachment;
import ch.systemsx.cisd.lims.base.ExperimentIdentifier;
import ch.systemsx.cisd.lims.base.ExperimentPlatesFilter;
import ch.systemsx.cisd.lims.base.ExperimentType;
import ch.systemsx.cisd.lims.base.MaterialCriteria;
import ch.systemsx.cisd.lims.base.NewExperiment;
import ch.systemsx.cisd.lims.base.ProcedureTypeCode;
import ch.systemsx.cisd.lims.base.ProcessingInstruction;
import ch.systemsx.cisd.lims.base.ProcessingParameters;
import ch.systemsx.cisd.lims.base.QueryRestriction;
import ch.systemsx.cisd.lims.base.properties.EntityKind;
import ch.systemsx.cisd.lims.server.business.AbstractManager;
import ch.systemsx.cisd.lims.server.business.IExperimentManager;
import ch.systemsx.cisd.lims.server.business.IProcessingInstructionValidator;
import ch.systemsx.cisd.lims.server.business.IScreeningProcessStrategy;
import ch.systemsx.cisd.lims.server.business.IStrategyFactory;
import ch.systemsx.cisd.lims.server.business.ParameterChecker;
import ch.systemsx.cisd.lims.server.business.Session;
import ch.systemsx.cisd.lims.server.business.StrategyFactoryProvider;
import ch.systemsx.cisd.lims.server.business.bo.IBusinessObjectFactory;
import ch.systemsx.cisd.lims.server.business.bo.IEntityPropertiesConverter;
import ch.systemsx.cisd.lims.server.business.bo.IExperimentBO;
import ch.systemsx.cisd.lims.server.business.bo.IExperimentTable;
import ch.systemsx.cisd.lims.server.business.bo.IProcedureBO;
import ch.systemsx.cisd.lims.server.business.bo.IProcedureTable;
import ch.systemsx.cisd.lims.server.business.bo.IProcessingInstructionTable;
import ch.systemsx.cisd.lims.server.business.bo.IProjectBO;
import ch.systemsx.cisd.lims.server.business.bo.ISampleBO;
import ch.systemsx.cisd.lims.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.lims.server.dto.BaseExperimentDTO;
import ch.systemsx.cisd.lims.server.dto.ExperimentDTO;
import ch.systemsx.cisd.lims.server.dto.ExperimentFileAttachmentDTO;
import ch.systemsx.cisd.lims.server.dto.ExperimentTypeDTO;
import ch.systemsx.cisd.lims.server.dto.ProcedureDTO;
import ch.systemsx.cisd.lims.server.dto.ProcessingInstructionDTO;
import ch.systemsx.cisd.lims.server.dto.SampleDTO;
import java.util.ArrayList;
import java.util.List;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ExperimentManager
extends AbstractManager
implements IExperimentManager {
    private final IProcessingInstructionValidator processingInstructionValidator;

    ExperimentManager(IDAOFactory daoFactory, StrategyFactoryProvider strategyProvider, IBusinessObjectFactory boFactory, IProcessingInstructionValidator processingInstructionValidator) {
        super(daoFactory, strategyProvider, boFactory);
        this.processingInstructionValidator = processingInstructionValidator;
    }

    private final SampleDTO tryGetSample(Session session, String sampleCode) {
        ISampleBO sampleBO = this.boFactory.createSampleBO(session);
        try {
            sampleBO.loadBySampleCode(sampleCode);
        }
        catch (UserFailureException userFailureException) {
            return null;
        }
        return sampleBO.getSample();
    }

    private IExperimentBO loadBasicExperimentInfo(Session session, ExperimentIdentifier experimentIdentifier) {
        IExperimentBO experimentBO = this.boFactory.createExperimentBO(session);
        experimentBO.loadByExperimentIdentifier(experimentIdentifier, false);
        experimentBO.enrichWithMaterialProperties();
        experimentBO.enrichWithProcessingInstructions();
        experimentBO.enrichWithInvalidation();
        experimentBO.enrichWithProperties();
        experimentBO.enrichWithAttachments();
        return experimentBO;
    }

    private ExperimentDTO saveExperiment(Session session, NewExperiment newExperiment) {
        IExperimentBO experimentBO = this.boFactory.createExperimentBO(session);
        experimentBO.fill(newExperiment);
        experimentBO.save();
        ExperimentDTO experiment = experimentBO.getExperiment();
        return experiment;
    }

    private ProcedureDTO saveProcedure(Session session, ExperimentDTO experiment) {
        IProcedureBO procedureBO = this.boFactory.createProcedureBO(session);
        procedureBO.define(experiment.getId(), ProcedureTypeCode.DATA_ACQUISITION.getCode());
        procedureBO.save();
        ProcedureDTO procedure = procedureBO.getProcedure();
        return procedure;
    }

    private void saveProcessingInstructions(Session session, ProcessingInstruction[] processingInstructions, ExperimentDTO experiment) {
        IProcessingInstructionTable processingInstructionTable = this.boFactory.createProcessingInstructionTable(session);
        Long experimentID = experiment.getId();
        processingInstructionTable.fill(experimentID, processingInstructions, this.processingInstructionValidator);
        processingInstructionTable.save();
    }

    private IScreeningProcessStrategy createScreeningStrategy(Session session, Long groupId) {
        IStrategyFactory strategyFactory = this.getStrategyFactory(groupId);
        IScreeningProcessStrategy strategy = strategyFactory.createScreeningProcessStrategy(this.daoFactory, this.boFactory, session);
        return strategy;
    }

    private final ExperimentDTO getExperimentInfo(Session session, ExperimentIdentifier experimentIdentifier, boolean withSamples, boolean withDatasets, ExperimentPlatesFilter filter) throws UserFailureException {
        ParameterChecker.checkIfNotNull(session, "session");
        ParameterChecker.checkExperimentIdentifier(experimentIdentifier);
        IExperimentBO experimentBO = this.loadBasicExperimentInfo(session, experimentIdentifier);
        ExperimentDTO experiment = experimentBO.getExperiment();
        List<ProcedureDTO> procedures = this.loadExperimentProcedures(session, experiment.getId(), withSamples, withDatasets);
        experiment.setProcedures(procedures.toArray(new ProcedureDTO[procedures.size()]));
        ExperimentManager.filterExperiments(experiment, filter);
        IEntityPropertiesConverter experimentConverter = this.boFactory.createEntityPropertiesConverter(EntityKind.EXPERIMENT);
        experiment.setSimpleProperties(experimentConverter.convertProperties(experiment));
        return experiment;
    }

    private static ExperimentDTO filterExperiments(ExperimentDTO experiment, ExperimentPlatesFilter filter) {
        ProcedureDTO[] procedures;
        if (filter == null) {
            return experiment;
        }
        ProcedureDTO[] procedureDTOArray = procedures = experiment.getProcedures();
        int n = procedures.length;
        int n2 = 0;
        while (n2 < n) {
            ProcedureDTO procedure = procedureDTOArray[n2];
            SampleDTO[] procSamples = procedure.getResultSamples();
            if (procSamples != null) {
                ArrayList<SampleDTO> samples = new ArrayList<SampleDTO>();
                SampleDTO[] sampleDTOArray = procSamples;
                int n3 = procSamples.length;
                int n4 = 0;
                while (n4 < n3) {
                    SampleDTO procSample = sampleDTOArray[n4];
                    if (procSample.getInvalidation() == null || !filter.isHideInvalidated()) {
                        samples.add(procSample);
                    }
                    ++n4;
                }
                procedure.setResultSamples(samples.toArray(new SampleDTO[samples.size()]));
            }
            ++n2;
        }
        return experiment;
    }

    private List<ProcedureDTO> loadExperimentProcedures(Session session, Long experimentId, boolean withPlates, boolean withDatasets) {
        IProcedureTable procedureTable = this.boFactory.createProcedureTable(session);
        procedureTable.loadByExperimentID(experimentId);
        procedureTable.enrichWithControlLayout();
        if (withDatasets) {
            procedureTable.enrichWithScreenablePlatesAndData();
        } else if (withPlates) {
            procedureTable.enrichWithScreenablePlates();
        }
        ArrayList<ProcedureDTO> procedures = new ArrayList<ProcedureDTO>();
        for (ProcedureDTO procedureDTO : procedureTable) {
            procedures.add(procedureDTO);
        }
        return procedures;
    }

    @Override
    @Transactional
    public final ExperimentType[] listExperimentTypes() {
        List<ExperimentTypeDTO> list = this.daoFactory.getExperimentTypeDAO().listExperimentTypes();
        return BeanUtils.createBeanList(ExperimentType.class, list).toArray(new ExperimentType[list.size()]);
    }

    @Override
    @Transactional
    public final BaseExperimentDTO[] listExperiments(Session session, QueryRestriction queryRestriction) throws UserFailureException {
        ParameterChecker.checkQueryRestriction(queryRestriction);
        Long projectID = null;
        String projectCode = queryRestriction.getProjectCode();
        if (projectCode != null) {
            IProjectBO project = this.boFactory.createProjectBO(session);
            project.load(projectCode);
            projectID = project.getProject().getId();
        }
        Long studyObjectID = null;
        MaterialCriteria materialCriteria = queryRestriction.getMaterialCriteria();
        if (materialCriteria != null) {
            String studyObjectCode = materialCriteria.getCode();
            assert (studyObjectCode != null) : "If we have a material criteria, we must have at least the study object code.";
            studyObjectID = this.daoFactory.getMaterialDAO().tryFindMaterialIdByCodeAndTypeCode(studyObjectCode, materialCriteria.getTypeCode());
            if (studyObjectID == null) {
                throw new UserFailureException("Unknown study object '" + studyObjectCode + "'.");
            }
        }
        IExperimentTable experimentTable = this.boFactory.createExperimentTable(session);
        experimentTable.load(queryRestriction.getExperimentTypeCode(), queryRestriction.isSuppressInvalidated());
        experimentTable.filterBy(projectID, studyObjectID, queryRestriction.getTimeInterval());
        experimentTable.enrichWithProjectAndGroup();
        experimentTable.enrichWithRegistrator();
        experimentTable.enrichWithStudyObject();
        experimentTable.enrichWithTypes();
        experimentTable.enrichWithProperties();
        IEntityPropertiesConverter experimentConverter = this.boFactory.createEntityPropertiesConverter(EntityKind.EXPERIMENT);
        for (BaseExperimentDTO baseExperimentDTO : experimentTable) {
            baseExperimentDTO.setSimpleProperties(experimentConverter.convertProperties(baseExperimentDTO));
        }
        return experimentTable.getBaseExperiments().toArray(BaseExperimentDTO.EMPTY_ARRAY);
    }

    @Override
    @Transactional
    public final BaseExperiment tryGetBaseExperiment(Session session, ExperimentIdentifier experimentIdentifierOrNull, String sampleCode) throws UserFailureException {
        IExperimentBO experiment = this.boFactory.createExperimentBO(session);
        if (experimentIdentifierOrNull != null) {
            experiment.loadByExperimentIdentifier(experimentIdentifierOrNull, true);
        } else {
            ParameterChecker.checkIfNotNull(sampleCode, "sample code");
            SampleDTO sample = this.tryGetSample(session, sampleCode);
            if (sample == null) {
                return null;
            }
            Long procedureId = sample.getProcedureID();
            if (procedureId != null) {
                experiment.loadByProcedureID(procedureId, true);
            }
        }
        experiment.enrichWithProcessingInstructions();
        ExperimentDTO experimentDTO = experiment.getExperiment();
        if (experimentDTO == null) {
            return null;
        }
        BaseExperiment result = BeanUtils.createBean(BaseExperiment.class, experimentDTO);
        result.setInvalidated(experimentDTO.getInvalidationId() != null);
        ProcessingInstructionDTO[] processingInstructions = experimentDTO.getProcessingInstructions();
        if (processingInstructions != null) {
            int i = 0;
            while (i < processingInstructions.length) {
                ProcessingInstructionDTO processingInstruction = processingInstructions[i];
                byte[] bytes = processingInstruction.getParameters();
                ProcessingParameters parameters = ProcessingParameters.tryToCreateFromBinary(bytes);
                result.getProcessingInstructions()[i].setParameters(parameters);
                ++i;
            }
        }
        return result;
    }

    @Override
    @Transactional
    public final void registerExperiments(Session session, NewExperiment[] newExperiments) throws UserFailureException {
        NewExperiment[] newExperimentArray = newExperiments;
        int n = newExperiments.length;
        int n2 = 0;
        while (n2 < n) {
            NewExperiment newExperiment = newExperimentArray[n2];
            try {
                ExperimentDTO experiment = this.saveExperiment(session, newExperiment);
                ProcedureDTO procedure = this.saveProcedure(session, experiment);
                this.saveProcessingInstructions(session, newExperiment.getProcessingInstructions(), experiment);
                IScreeningProcessStrategy strategy = this.createScreeningStrategy(session, experiment.getProject().getGroupId());
                strategy.registerPlatesOnExperimentRegistration(newExperiment.getCellPlates(), newExperiment.getControlLayoutCode(), procedure.getId());
            }
            catch (Exception e) {
                ExperimentIdentifier identifier = new ExperimentIdentifier(newExperiment.getProjectCode(), newExperiment.getCode());
                throw new UserFailureException("Experiment '" + identifier + "'" + " couldn't be registered. " + e.getMessage());
            }
            ++n2;
        }
    }

    @Override
    @Transactional
    public final void addExperimentFileAttachment(Session session, ExperimentIdentifier experimentIdentifier, ExperimentFileAttachment property) throws UserFailureException {
        ParameterChecker.checkIfNotNull(session, "session");
        ParameterChecker.checkExperimentIdentifier(experimentIdentifier);
        ParameterChecker.checkExperimentFileProperty(property);
        IExperimentBO experimentBO = this.boFactory.createExperimentBO(session);
        experimentBO.loadByExperimentIdentifier(experimentIdentifier, false);
        experimentBO.addAttachment(property);
        experimentBO.save();
    }

    @Override
    @Transactional
    public final ExperimentDTO getExperimentInfoWithPlates(Session session, ExperimentIdentifier experimentIdentifier, ExperimentPlatesFilter filter) throws UserFailureException {
        return this.getExperimentInfo(session, experimentIdentifier, true, false, filter);
    }

    @Override
    @Transactional
    public final ExperimentDTO getExperimentInfoWithDatasets(Session session, ExperimentIdentifier experimentIdentifier, ExperimentPlatesFilter filter) throws UserFailureException {
        return this.getExperimentInfo(session, experimentIdentifier, true, true, filter);
    }

    @Override
    @Transactional
    public final ExperimentDTO getExperimentInfoBasic(Session session, ExperimentIdentifier experimentIdentifier) throws UserFailureException {
        return this.getExperimentInfo(session, experimentIdentifier, false, false, null);
    }

    @Override
    @Transactional
    public final ExperimentFileAttachmentDTO getExperimentFileAttachment(Session session, ExperimentIdentifier experimentIdentifier, String filename, int version) throws UserFailureException {
        ParameterChecker.checkExperimentIdentifier(experimentIdentifier);
        IExperimentBO experimentBO = this.boFactory.createExperimentBO(session);
        experimentBO.loadByExperimentIdentifier(experimentIdentifier, false);
        return experimentBO.getExperimentFileAttachment(filename, version);
    }

    @Override
    @Transactional
    public final void invalidate(Session session, ExperimentIdentifier experimentIdentifier, String invalidationReasonOrNull) {
        ParameterChecker.checkExperimentIdentifier(experimentIdentifier);
        IExperimentBO experimentBO = this.boFactory.createExperimentBO(session);
        experimentBO.loadByExperimentIdentifier(experimentIdentifier, false);
        experimentBO.invalidateExperiment(invalidationReasonOrNull);
    }
}

