/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.business;

import ch.systemsx.cisd.common.collections.FilteredList;
import ch.systemsx.cisd.common.collections.TableMap;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.common.utilities.BeanUtils;
import ch.systemsx.cisd.lims.base.ExperimentIdentifier;
import ch.systemsx.cisd.lims.base.ExternalData;
import ch.systemsx.cisd.lims.base.LimitFilter;
import ch.systemsx.cisd.lims.base.MoleculeCriteria;
import ch.systemsx.cisd.lims.base.NewSample;
import ch.systemsx.cisd.lims.base.NewSampleComponent;
import ch.systemsx.cisd.lims.base.PlateDimension;
import ch.systemsx.cisd.lims.base.PlateLocation;
import ch.systemsx.cisd.lims.base.ProcedureTypeCode;
import ch.systemsx.cisd.lims.base.Sample;
import ch.systemsx.cisd.lims.base.SampleComponent;
import ch.systemsx.cisd.lims.base.SampleComponentsLayout;
import ch.systemsx.cisd.lims.base.SampleCriteria;
import ch.systemsx.cisd.lims.base.SampleFilter;
import ch.systemsx.cisd.lims.base.SampleGeneration;
import ch.systemsx.cisd.lims.base.SampleTypeCode;
import ch.systemsx.cisd.lims.base.WellCoordinates;
import ch.systemsx.cisd.lims.base.properties.EntityKind;
import ch.systemsx.cisd.lims.base.properties.SimpleEntityProperty;
import ch.systemsx.cisd.lims.base.util.PlateDimensionParser;
import ch.systemsx.cisd.lims.server.business.AbstractManager;
import ch.systemsx.cisd.lims.server.business.ISampleManager;
import ch.systemsx.cisd.lims.server.business.IScreeningProcessStrategy;
import ch.systemsx.cisd.lims.server.business.IStrategyFactory;
import ch.systemsx.cisd.lims.server.business.ParameterChecker;
import ch.systemsx.cisd.lims.server.business.SampleValidator;
import ch.systemsx.cisd.lims.server.business.Session;
import ch.systemsx.cisd.lims.server.business.StrategyFactoryProvider;
import ch.systemsx.cisd.lims.server.business.bo.IBusinessObjectFactory;
import ch.systemsx.cisd.lims.server.business.bo.IEntityPropertiesConverter;
import ch.systemsx.cisd.lims.server.business.bo.IExperimentBO;
import ch.systemsx.cisd.lims.server.business.bo.IExternalDataBO;
import ch.systemsx.cisd.lims.server.business.bo.IMaterialTable;
import ch.systemsx.cisd.lims.server.business.bo.IPersonBO;
import ch.systemsx.cisd.lims.server.business.bo.IProcedureBO;
import ch.systemsx.cisd.lims.server.business.bo.IProcedureTable;
import ch.systemsx.cisd.lims.server.business.bo.ISampleBO;
import ch.systemsx.cisd.lims.server.business.bo.ISampleComponentTable;
import ch.systemsx.cisd.lims.server.business.bo.ISampleTable;
import ch.systemsx.cisd.lims.server.business.bo.ISampleTree;
import ch.systemsx.cisd.lims.server.business.bo.SampleCriteriaWithId;
import ch.systemsx.cisd.lims.server.business.bo.SampleLayoutCriterias;
import ch.systemsx.cisd.lims.server.business.plateutil.PlateWellCoordsParser;
import ch.systemsx.cisd.lims.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.lims.server.dataaccess.IExternalDataDAO;
import ch.systemsx.cisd.lims.server.dataaccess.IInvalidationDAO;
import ch.systemsx.cisd.lims.server.dto.ExperimentDTO;
import ch.systemsx.cisd.lims.server.dto.ExternalDataDTO;
import ch.systemsx.cisd.lims.server.dto.InvalidationDTO;
import ch.systemsx.cisd.lims.server.dto.MaterialDTO;
import ch.systemsx.cisd.lims.server.dto.PlateLocationDTO;
import ch.systemsx.cisd.lims.server.dto.ProcedureDTO;
import ch.systemsx.cisd.lims.server.dto.SampleComponentDTO;
import ch.systemsx.cisd.lims.server.dto.SampleDTO;
import ch.systemsx.cisd.lims.server.dto.SampleGenerationDTO;
import ch.systemsx.cisd.lims.server.dto.SampleTypeDTO;
import ch.systemsx.cisd.lims.server.util.KeyExtractorFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
final class SampleManager
extends AbstractManager
implements ISampleManager {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, SampleManager.class);
    private final IMailClient mailClient;

    public SampleManager(IDAOFactory daoFactory, StrategyFactoryProvider strategyProvider, IBusinessObjectFactory boFactory, IMailClient mailClient) {
        super(daoFactory, strategyProvider, boFactory);
        assert (mailClient != null) : "Undefined e-mail client";
        this.mailClient = mailClient;
    }

    private final IScreeningProcessStrategy createProcessStrategy(Session session) {
        IStrategyFactory strategyFactory = this.getStrategyFactory(session.getGroupId());
        IScreeningProcessStrategy screeningProcessStrategy = strategyFactory.createScreeningProcessStrategy(this.daoFactory, this.boFactory, session);
        return screeningProcessStrategy;
    }

    private final void checkConsistency(Session session, ExperimentDTO experimentDTO, long procedureID, ISampleBO sampleBO) {
        List<String> codes = sampleBO.calculateComponentsLayoutConsistency();
        SampleDTO cellPlate = sampleBO.getSample();
        if (codes.size() > 0) {
            String body = String.format("openBIS server: cell plate '%s' in experiment '%s' has inconsistent layout of master plate and control plates. Overlapping codes are '%s'", cellPlate.getCode(), experimentDTO.getCode(), codes);
            this.sendEMail(experimentDTO, body);
        }
    }

    private final void sendEMail(ExperimentDTO experiment, String body) throws UserFailureException {
        String to = experiment.getRegistrator().getEmail();
        String experimentCode = experiment.getCode();
        ExperimentIdentifier identifier = new ExperimentIdentifier(experiment.getProject().getCode(), experimentCode);
        String subject = "ATTENTION: experiment '" + identifier + "'";
        try {
            this.mailClient.sendMessage(subject, body, to);
        }
        catch (EnvironmentFailureException ex) {
            operationLog.error(ex.getMessage());
        }
    }

    private final SampleComponent[] convert(Iterable<SampleComponentDTO> components, TableMap<Long, SampleCriteriaWithId> sampleCriteriaMap) {
        BeanUtils.Converter converter = this.createSampleComponentsConverter(sampleCriteriaMap);
        return BeanUtils.createBeanArray(SampleComponent.class, components, converter);
    }

    private final PlateLocation[] convert(Collection<PlateLocationDTO> plateLocations) {
        SampleConverter converter = new SampleConverter(){

            public WellCoordinates convertToWellCoordinates(SampleComponentDTO component) {
                return SampleManager.convertWellCoords(component);
            }
        };
        return BeanUtils.createBeanArray(PlateLocation.class, plateLocations, (BeanUtils.Converter)converter);
    }

    private final BeanUtils.Converter createSampleComponentsConverter(final TableMap<Long, SampleCriteriaWithId> sampleCriteriaMap) {
        return new AbstractManager.MaterialConverter(this){

            public WellCoordinates convertToWellCoordinates(SampleComponentDTO component) {
                return SampleManager.convertWellCoords(component);
            }

            public SampleCriteria convertToSampleCriteria(SampleComponentDTO component) {
                Long sampleID = component.getSampleID();
                SampleCriteriaWithId fullCriteria = (SampleCriteriaWithId)sampleCriteriaMap.tryGet(sampleID);
                return fullCriteria.getSampleCriteria();
            }
        };
    }

    private static final WellCoordinates convertWellCoords(SampleComponentDTO component) {
        String wellCode = component.getCode();
        WellCoordinates coords = PlateWellCoordsParser.tryParseCoords(wellCode);
        assert (coords != null) : "incorrect well code format in the db: " + wellCode;
        return coords;
    }

    private final SampleComponentsLayout convert(List<SampleComponentDTO> components, SampleLayoutCriterias layoutCriterias) {
        SampleComponent[] sampleComponents = this.convertComponents(components, layoutCriterias);
        SampleCriteria[] controlSamples = SampleManager.convert(layoutCriterias.getConnectedControlSamples());
        SampleCriteria mainSample = SampleManager.convert(layoutCriterias.getMainSample());
        return new SampleComponentsLayout(controlSamples, mainSample, sampleComponents);
    }

    private final SampleComponent[] convertComponents(List<SampleComponentDTO> components, SampleLayoutCriterias layoutCriterias) {
        TableMap<Long, SampleCriteriaWithId> sampleCriteriaMap = this.createSampleCriteriaMap(layoutCriterias.getAllCriterias());
        return this.convert(components, sampleCriteriaMap);
    }

    private static final SampleCriteria[] convert(List<SampleCriteriaWithId> list) {
        SampleCriteria[] result = new SampleCriteria[list.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = SampleManager.convert(list.get(i));
            ++i;
        }
        return result;
    }

    private static final SampleCriteria convert(SampleCriteriaWithId sample) {
        return sample.getSampleCriteria();
    }

    private final TableMap<Long, SampleCriteriaWithId> createSampleCriteriaMap(List<SampleCriteriaWithId> layoutCriterias) {
        return new TableMap<Long, SampleCriteriaWithId>(layoutCriterias, KeyExtractorFactory.getSampleCriteriaWithIdKeyExtractor());
    }

    private final ISampleBO registerSample(Session session, NewSample newSample) {
        ISampleBO sampleBO = this.boFactory.createSampleBO(session);
        sampleBO.define(newSample);
        this.checkPlateDimensionConsistency(session, newSample, sampleBO.getSample().getTopID());
        sampleBO.save();
        return sampleBO;
    }

    private final void checkPlateDimensionConsistency(Session session, NewSample newSample, Long topIdOrNull) {
        PlateDimension topSampleDim;
        PlateDimension controlLayoutDim;
        String controlLayoutCode = newSample.getControlLayoutCode();
        if (controlLayoutCode != null && !(controlLayoutDim = this.getPlateDimension(session, controlLayoutCode)).equals(topSampleDim = this.getTopSampleDimension(session, newSample, topIdOrNull))) {
            throw UserFailureException.fromTemplate("Plate sizes do not match. Control layout '%s' has a size %s and the plate '%s' size is %s. They should be equal.", controlLayoutCode, controlLayoutDim, newSample.getSampleCriteria(), topSampleDim);
        }
    }

    private final PlateDimension getTopSampleDimension(Session session, NewSample newSample, Long topIdOrNull) {
        if (topIdOrNull != null) {
            String topSampleCode = this.daoFactory.getSampleDAO().getSampleCodeById(topIdOrNull);
            return this.getPlateDimension(session, topSampleCode);
        }
        return PlateDimensionParser.getPlateDimension(newSample.getProperties());
    }

    private Long getRegistratorId(Session session) {
        IPersonBO personBO = this.boFactory.createPersonBO(session);
        return personBO.getLoggedInUserId();
    }

    private final Sample[] convert(List<SampleDTO> samples) {
        BeanUtils.Converter converter = this.createSampleAndExpPropertiesConverter();
        return BeanUtils.createBeanArray(Sample.class, samples, converter);
    }

    private final Sample convert(SampleDTO sample) {
        BeanUtils.Converter converter = this.createSampleAndExpPropertiesConverter();
        return BeanUtils.createBean(Sample.class, sample, converter);
    }

    private final SampleGeneration convert(SampleGenerationDTO sampleGenerationDTO) {
        BeanUtils.Converter converter = this.createSampleAndExpPropertiesConverter();
        return BeanUtils.createBean(SampleGeneration.class, sampleGenerationDTO, converter);
    }

    private final BeanUtils.Converter createSampleAndExpPropertiesConverter() {
        return new SampleConverter(null, null);
    }

    private void checkSampleComponents(NewSample sample, NewSampleComponent[] sampleComponents) {
        PlateDimension plateDimension = PlateDimensionParser.getPlateDimension(sample.getProperties());
        ParameterChecker.checkSampleComponents(sampleComponents, plateDimension);
    }

    private void registerAndCheckSample(Session session, NewSample newSample) {
        ISampleBO sampleBO = this.registerSample(session, newSample);
        sampleBO.checkSampleConsistency();
    }

    private boolean isGeneratorValid(Session session, NewSample sample) {
        String generatedFromCode = sample.getGeneratedFrom();
        ISampleBO sampleBO = this.boFactory.createSampleBO(session);
        sampleBO.loadSimpleBySampleCode(generatedFromCode);
        SampleDTO generator = sampleBO.getSample();
        return generator.getInvalidation() == null;
    }

    private SampleDTO getTopSampleWithProperties(Session session, String sampleCode) {
        ISampleBO sampleBO = this.boFactory.createSampleBO(session);
        sampleBO.loadSimpleBySampleCode(sampleCode);
        SampleDTO s = sampleBO.getSample();
        SampleDTO topSample = s.getTop();
        if (topSample != null) {
            sampleBO.loadSimpleBySampleCode(topSample.getCode());
        }
        sampleBO.enrichWithProperties();
        return sampleBO.getSample();
    }

    private Iterable<SampleComponentDTO> getSampleComponents(Session session, Long sampleId, boolean enrichMaterials) {
        ISampleComponentTable componentTable = this.boFactory.createSampleComponentTable(session);
        componentTable.loadBySampleID(sampleId);
        if (enrichMaterials) {
            componentTable.enrichWithMaterialProperties();
            componentTable.enrichWithFullInhibitor();
        }
        return componentTable;
    }

    private List<SampleComponentDTO> mergeComponents(Session session, List<SampleCriteriaWithId> layoutCriterias, boolean enrichMaterials) {
        ArrayList<SampleComponentDTO> result = new ArrayList<SampleComponentDTO>();
        for (SampleCriteriaWithId layoutCriteria : layoutCriterias) {
            long sampleId = layoutCriteria.getSampleId();
            Iterable<SampleComponentDTO> components = this.getSampleComponents(session, sampleId, enrichMaterials);
            SampleManager.addAll(result, components);
        }
        return result;
    }

    private static <T> void addAll(Collection<T> collection, Iterable<T> newElements) {
        for (T elem : newElements) {
            collection.add(elem);
        }
    }

    @Override
    @Transactional
    public SimpleEntityProperty[] tryToGetPropertiesOfTopSampleRegisteredFor(Session session, String sampleCode) throws UserFailureException {
        ParameterChecker.checkIfNotNull(sampleCode, "sample code");
        IScreeningProcessStrategy screeningProcessStrategy = this.createProcessStrategy(session);
        SampleDTO sample = screeningProcessStrategy.tryToGetTopSampleRegisteredFor(sampleCode);
        if (sample == null) {
            return null;
        }
        return this.convert(sample).getProperties();
    }

    @Override
    @Transactional
    public final void registerDataSet(Session session, ExperimentIdentifier experimentIdentifierOrNull, String sampleCode, String procedureTypeCode, ExternalData data) throws UserFailureException {
        ProcedureDTO dataAcquisitionProcedure;
        boolean dataAcquisition;
        ParameterChecker.checkIfNotNull(sampleCode, "sample code");
        ParameterChecker.checkProcedureTypeCode(procedureTypeCode);
        ParameterChecker.checkExternalData(data);
        IExperimentBO experimentBO = this.boFactory.createExperimentBO(session);
        experimentBO.loadByExperimentIdentifierOrSampleCode(experimentIdentifierOrNull, sampleCode);
        ExperimentDTO experimentDTO = experimentBO.getExperiment();
        assert (experimentDTO != null) : "Experiment can not be null.";
        if (experimentDTO.getInvalidationId() != null) {
            throw new UserFailureException("Data set can not be registered because experiment '" + experimentDTO.getCode() + "' is invalid.");
        }
        IProcedureBO procedureBO = this.boFactory.createProcedureBO(session);
        procedureBO.loadByExperimentIDAndType(experimentDTO.getId(), procedureTypeCode);
        ProcedureDTO procedure = procedureBO.getProcedure();
        if (procedure == null) {
            procedureBO.define(experimentDTO.getId(), procedureTypeCode);
            procedureBO.save();
            procedure = procedureBO.getProcedure();
        }
        if (dataAcquisition = procedureTypeCode.equals(ProcedureTypeCode.DATA_ACQUISITION.getCode())) {
            dataAcquisitionProcedure = procedure;
        } else {
            IProcedureBO acquisitionProcedureBO = this.boFactory.createProcedureBO(session);
            acquisitionProcedureBO.loadByExperimentIDAndType(experimentDTO.getId(), ProcedureTypeCode.DATA_ACQUISITION.getCode());
            dataAcquisitionProcedure = acquisitionProcedureBO.getProcedure();
        }
        ISampleBO sampleBO = this.boFactory.createSampleBO(session);
        sampleBO.loadOrCreateSampleForDataSet(sampleCode, dataAcquisitionProcedure.getId());
        SampleDTO cellPlate = sampleBO.getSample();
        assert (cellPlate.getProcedureID() != null) : "Any cell plate should have been connected to one procedure.";
        IExternalDataBO externalDataBO = this.boFactory.createExternalDataBO(session);
        IExternalDataDAO.SourceType type = dataAcquisition ? IExternalDataDAO.SourceType.MEASUREMENT : IExternalDataDAO.SourceType.DERIVED;
        externalDataBO.define(data, procedure.getId(), cellPlate.getId(), type);
        externalDataBO.save();
        String parentDataSetCode = data.getParentDataSetCode();
        if (parentDataSetCode != null) {
            externalDataBO.linkToParent(parentDataSetCode, experimentDTO.getId());
        }
        this.checkConsistency(session, experimentDTO, dataAcquisitionProcedure.getId(), sampleBO);
    }

    @Override
    @Transactional
    public ExternalDataDTO getDataSet(Session session, String dataSetCode) throws UserFailureException {
        IExternalDataBO externalDataBO = this.boFactory.createExternalDataBO(session);
        externalDataBO.loadByDataSetCode(dataSetCode);
        externalDataBO.enricheWithProcedureExperimentProjectGroup();
        return externalDataBO.getExternalData();
    }

    @Override
    @Transactional
    public final Sample[] listSamples(Session session, String sampleTypeCode, SampleFilter filter, LimitFilter limitFilter, boolean enrichWithRelations) throws UserFailureException {
        ParameterChecker.checkIfNotNull(sampleTypeCode, "sample type code");
        ISampleTable sampleTable = this.boFactory.createSampleTable(session);
        sampleTable.loadBySampleType(sampleTypeCode, enrichWithRelations);
        sampleTable.enrichParentAndTopWithInvalidation();
        sampleTable.enrichWithProperties();
        sampleTable.enrichWithFullHierarchy();
        List<SampleDTO> samples = sampleTable.getSamples();
        if (filter != null) {
            samples = FilteredList.decorate(samples, new SampleValidator(filter));
        }
        if (limitFilter != null) {
            samples = SampleManager.subList(limitFilter, samples);
        }
        Sample[] result = this.convert(samples);
        return result;
    }

    @Override
    @Transactional
    public final PlateLocation[] getPlateLocations(Session session, ExperimentIdentifier experimentIdentifier, MoleculeCriteria moleculeCriteria, boolean showInvalidated) throws UserFailureException {
        ParameterChecker.checkExperimentIdentifier(experimentIdentifier);
        ParameterChecker.checkMoleculeCriteria(moleculeCriteria);
        IExperimentBO experimentBO = this.boFactory.createExperimentBO(session);
        experimentBO.loadByExperimentIdentifier(experimentIdentifier, false);
        Long experimentID = experimentBO.getExperiment().getId();
        IProcedureTable procedureTable = this.boFactory.createProcedureTable(session);
        procedureTable.loadByExperimentID(experimentID);
        procedureTable.enrichWithScreenablePlates();
        ISampleTable sampleTable = this.boFactory.createSampleTable(session);
        for (ProcedureDTO procedure : procedureTable) {
            sampleTable.addSamples(procedure.getResultSamples());
        }
        IMaterialTable materialTable = this.boFactory.createMaterialTable(session);
        materialTable.loadByMoleculeCriteria(moleculeCriteria);
        Set<MaterialDTO> inhibitors = materialTable.findInhibitors();
        Collection<PlateLocationDTO> plateLocations = sampleTable.findPlateLocationsFor(inhibitors, showInvalidated);
        return this.convert(plateLocations);
    }

    @Override
    @Transactional
    public final SampleComponentsLayout getSampleMergedLayout(Session session, String sampleCode, boolean enrichMaterials) throws UserFailureException {
        ParameterChecker.checkIfNotNull(sampleCode, "sample code");
        ISampleBO sampleBO = this.boFactory.createSampleBO(session);
        sampleBO.loadSimpleBySampleCode(sampleCode);
        SampleLayoutCriterias layoutCriterias = sampleBO.calculateComponentsLayoutCriterias();
        List<SampleComponentDTO> components = this.mergeComponents(session, layoutCriterias.getAllCriterias(), enrichMaterials);
        return this.convert(components, layoutCriterias);
    }

    @Override
    @Transactional
    public void registerSampleWithComponents(Session session, NewSample sample, NewSampleComponent[] sampleComponents, String materialBatchCodeOrNull) {
        assert (sample != null) : "Sample not specified.";
        assert (sample.getSampleCriteria() != null) : "Sample code not specified.";
        ISampleBO sampleBO = this.registerSample(session, sample);
        this.checkSampleComponents(sample, sampleComponents);
        String materialBatchCode = materialBatchCodeOrNull;
        if (materialBatchCode == null) {
            materialBatchCode = sample.getSampleCriteria();
        }
        Long sampleId = sampleBO.getSample().getId();
        ISampleComponentTable sampleComponentTable = this.boFactory.createSampleComponentTable(session);
        sampleComponentTable.defineAndSave(sampleComponents, materialBatchCode, sampleId);
        sampleBO.checkSampleConsistency();
    }

    @Override
    @Transactional
    public void registerSamples(Session session, NewSample[] newSamples) {
        ParameterChecker.checkIfNotNull(newSamples, "sample(s)");
        NewSample[] newSampleArray = newSamples;
        int n = newSamples.length;
        int n2 = 0;
        while (n2 < n) {
            NewSample newSample = newSampleArray[n2];
            ParameterChecker.checkIfNotNull(newSample, "sample");
            if (!this.isGeneratorValid(session, newSample)) {
                throw UserFailureException.fromTemplate("Cannot register plate '%s': plate '%s' is invalid.", newSample.getSampleCriteria(), newSample.getGeneratedFrom());
            }
            this.registerAndCheckSample(session, newSample);
            ++n2;
        }
    }

    @Override
    @Transactional
    public final SampleGeneration getSampleInfo(Session session, String sampleCode) throws UserFailureException {
        ParameterChecker.checkIfNotNull(sampleCode, "sample code");
        ISampleBO sampleBO = this.boFactory.createSampleBO(session);
        sampleBO.loadSimpleBySampleCode(sampleCode);
        sampleBO.enrichWithProperties();
        sampleBO.enrichWithFullHierarchy();
        SampleDTO generator = sampleBO.getSample();
        assert (generator.getSampleType() != null) : "Sample type can not be null";
        Long procedureID = generator.getProcedureID();
        SampleTypeCode sampleType = SampleTypeCode.getSampleTypeCode(generator.getSampleType().getCode());
        if (procedureID != null && !sampleType.equals((Object)SampleTypeCode.CONTROL_LAYOUT)) {
            sampleBO.calculateComponentsLayoutConsistency();
            IProcedureBO procedureBO = this.boFactory.createProcedureBO(session);
            procedureBO.loadByID(procedureID);
            ProcedureDTO procedure = procedureBO.getProcedure();
            IExperimentBO experimentBO = this.boFactory.createExperimentBO(session);
            experimentBO.loadByProcedureID(procedureID, false);
            procedure.setExperiment(experimentBO.getExperiment());
            generator.setProcedure(procedure);
        }
        List<SampleDTO> generated = this.daoFactory.getSampleDAO().listSampleByGeneratedFrom(generator.getId());
        SampleGenerationDTO sampleGenerationDTO = new SampleGenerationDTO(generator, generated);
        return this.convert(sampleGenerationDTO);
    }

    @Override
    @Transactional
    public PlateDimension getPlateDimension(Session session, String sampleCode) {
        SampleDTO sampleDTO = this.getTopSampleWithProperties(session, sampleCode);
        Sample sample = this.convert(sampleDTO);
        return PlateDimensionParser.getPlateDimension(sample.getProperties());
    }

    @Override
    @Transactional
    public String[] invalidateSamples(Session session, String[] sampleCodes, String invalidationReasonOrNull) {
        Long registratorId = this.getRegistratorId(session);
        IInvalidationDAO invalidationDAO = this.daoFactory.getInvalidationDAO();
        InvalidationDTO invalidation = new InvalidationDTO(registratorId);
        invalidation.setReason(invalidationReasonOrNull);
        invalidationDAO.createInvalidation(invalidation);
        ISampleTree sampleTree = this.boFactory.createSampleTree(session);
        String[] stringArray = sampleCodes;
        int n = sampleCodes.length;
        int n2 = 0;
        while (n2 < n) {
            String sampleCode = stringArray[n2];
            sampleTree.loadAndAddSampleAndDescendantsByCode(sampleCode);
            ++n2;
        }
        Collection<SampleDTO> invalidatedSamples = sampleTree.invalidate(invalidation, SampleTypeCode.CONTROL_LAYOUT.getCode());
        ArrayList<String> codes = new ArrayList<String>();
        for (SampleDTO sampleDTO : invalidatedSamples) {
            codes.add(sampleDTO.getCode());
        }
        return codes.toArray(new String[codes.size()]);
    }

    @Override
    @Transactional
    public List<SampleTypeDTO> listSampleTypes(Session session) {
        return this.daoFactory.getSampleTypeDAO().listSampleTypes();
    }

    @Override
    @Transactional
    public String createDataSetCode() {
        return this.daoFactory.getExternalDataDAO().createDataSetCode();
    }

    private class SampleConverter
    implements BeanUtils.Converter {
        private final IEntityPropertiesConverter sampleConverter;
        private final IEntityPropertiesConverter experimentConverter;

        private SampleConverter() {
            this.sampleConverter = SampleManager.this.boFactory.createEntityPropertiesConverter(EntityKind.SAMPLE);
            this.experimentConverter = SampleManager.this.boFactory.createEntityPropertiesConverter(EntityKind.EXPERIMENT);
        }

        public SimpleEntityProperty[] convertToProperties(SampleDTO entity) {
            return this.sampleConverter.convertProperties(entity);
        }

        public SimpleEntityProperty[] convertToProperties(ExperimentDTO entity) {
            return this.experimentConverter.convertProperties(entity);
        }

        /* synthetic */ SampleConverter(SampleConverter sampleConverter, SampleConverter sampleConverter2) {
            this();
        }
    }
}

