/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.business;

import ch.systemsx.cisd.common.collections.Validator;
import ch.systemsx.cisd.common.collections.ValidatorUtils;
import ch.systemsx.cisd.lims.base.SampleFilter;
import ch.systemsx.cisd.lims.server.dto.ProcedureDTO;
import ch.systemsx.cisd.lims.server.dto.SampleDTO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SampleValidator
implements Validator<SampleDTO> {
    private final Validator<String> validator;
    private final boolean experimentLess;
    private final boolean hideInvalidated;

    SampleValidator(SampleFilter filter) {
        String[] patterns = filter.getPatterns();
        this.validator = patterns.length == 0 ? ValidatorUtils.getAlwaysTrueValidator() : ValidatorUtils.createPatternValidator(patterns);
        this.experimentLess = filter.isNotRegisteredToExperiment();
        this.hideInvalidated = filter.isHideInvalidated();
    }

    @Override
    public final boolean isValid(SampleDTO sample) {
        ProcedureDTO procedure;
        if (!this.validator.isValid(sample.getCode())) {
            return false;
        }
        if (this.hideInvalidated && sample.getInvalidation() != null) {
            return false;
        }
        if (this.experimentLess && (procedure = sample.getProcedure()) != null) {
            return procedure.getExperiment() == null;
        }
        return true;
    }
}

