/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.business;

import ch.systemsx.cisd.authentication.Principal;
import ch.systemsx.cisd.lims.server.dto.GroupDTO;
import java.io.Serializable;
import org.apache.commons.lang.time.DateFormatUtils;

public final class Session
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String DATE_FORMAT_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private final String user;
    private final String sessionToken;
    private final Principal principal;
    private final GroupDTO group;
    private final long sessionStart;

    public Session(String user, String sessionToken, Principal principal, GroupDTO group, long sessionStart) {
        assert (user != null) : "Given user can not be null.";
        assert (sessionToken != null) : "Given session token can not be null.";
        assert (principal != null) : "Given principal can not be null.";
        assert (sessionStart > 0L) : "Given session start must be bigger than zero.";
        assert (group != null) : "Given group can not be null.";
        this.user = user;
        this.sessionToken = sessionToken;
        this.principal = principal;
        this.group = group;
        this.sessionStart = sessionStart;
    }

    public final String getUserName() {
        return this.user;
    }

    public final String getSessionToken() {
        return this.sessionToken;
    }

    public final Principal getPrincipal() {
        return this.principal;
    }

    public final long getGroupId() {
        return this.group.getId();
    }

    public final String getGroupCode() {
        return this.group.getCode();
    }

    public long getSessionStart() {
        return this.sessionStart;
    }

    public String toString() {
        return "Session{user=" + this.user + ",group=" + this.getGroupCode() + ",sessionstart=" + DateFormatUtils.format(this.getSessionStart(), DATE_FORMAT_PATTERN) + "}";
    }
}

