/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.business;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.lims.server.business.IStrategyFactory;
import ch.systemsx.cisd.lims.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.lims.server.dto.GroupDTO;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StrategyFactoryProvider {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, StrategyFactoryProvider.class);
    private final Map<Long, IStrategyFactory> idToFactoryMap;
    private final Map<String, IStrategyFactory> codeToFactoryMap;
    private final IStrategyFactory defaultFactory;

    public StrategyFactoryProvider(IDAOFactory daoFactory, Map<String, IStrategyFactory> factories, String codeOfDefaultFactory) {
        assert (daoFactory != null) : "Undefined DAO Factory";
        assert (factories != null && !factories.isEmpty()) : "Undefined factories";
        assert (codeOfDefaultFactory != null) : "Undefined code of default factory";
        this.codeToFactoryMap = factories;
        this.defaultFactory = factories.get(codeOfDefaultFactory);
        if (this.defaultFactory == null) {
            throw new ConfigurationFailureException("No Strategy Factory found for code '" + codeOfDefaultFactory + "'.");
        }
        this.idToFactoryMap = new HashMap<Long, IStrategyFactory>();
        List<GroupDTO> groups = daoFactory.getGroupDAO().listGroups();
        for (GroupDTO group : groups) {
            IStrategyFactory factory = this.defaultFactory;
            this.idToFactoryMap.put(group.getId(), factory);
            String factoryName = factory.getClass().getName();
            if (!operationLog.isInfoEnabled()) continue;
            operationLog.info("Strategy Factory '" + factoryName + "' registered for group " + group);
        }
    }

    private final IStrategyFactory assertNotNull(IStrategyFactory factory) {
        return factory == null ? this.defaultFactory : factory;
    }

    public final IStrategyFactory getFactory(String groupCode) {
        IStrategyFactory result = this.codeToFactoryMap.get(groupCode);
        return this.assertNotNull(result);
    }

    public final IStrategyFactory getFactory(long groupID) {
        IStrategyFactory result = this.idToFactoryMap.get(groupID);
        return this.assertNotNull(result);
    }
}

