/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.business.bo;

import ch.systemsx.cisd.common.collections.IKeyExtractor;
import ch.systemsx.cisd.common.collections.TableMap;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.lims.base.EntityPropertyFiller;
import ch.systemsx.cisd.lims.base.properties.EntityDataType;
import ch.systemsx.cisd.lims.base.properties.EntityPropertyValue;
import ch.systemsx.cisd.lims.server.business.bo.IKey;
import ch.systemsx.cisd.lims.server.business.bo.IPropertyValueProvider;
import ch.systemsx.cisd.lims.server.dataaccess.IVocabularyDAO;
import ch.systemsx.cisd.lims.server.dto.ICodeAndIDHolder;
import ch.systemsx.cisd.lims.server.dto.IUntypedValueSetter;
import ch.systemsx.cisd.lims.server.dto.PropertyTypeDTO;
import ch.systemsx.cisd.lims.server.dto.VocabularyTermDTO;
import ch.systemsx.cisd.lims.server.util.KeyExtractorFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractPropertyValueProvider
implements IPropertyValueProvider {
    private final String untypedDefaultValueOrNull;
    private Set<IKey> unmatchedValues = new LinkedHashSet<IKey>();
    private final TableMap<String, VocabularyTermDTO> vocabularyTermsByCode;
    private final PropertyTypeDTO propertyType;
    private TableMap<IKey, EntityPropertyFiller> newPropertyValues;

    AbstractPropertyValueProvider(PropertyTypeDTO propertyType, IVocabularyDAO vocabularyDAO, String untypedDefaultValueOrNull) {
        this.untypedDefaultValueOrNull = untypedDefaultValueOrNull;
        this.propertyType = propertyType;
        String vocabularyCode = propertyType.getVocabularyCode();
        if (vocabularyCode != null) {
            List<VocabularyTermDTO> vocabularyTerms = vocabularyDAO.listVocabularyTerms(vocabularyCode);
            this.vocabularyTermsByCode = new TableMap<String, VocabularyTermDTO>(vocabularyTerms, KeyExtractorFactory.getVocabularyTermByCodeKeyExtractor());
        } else {
            this.vocabularyTermsByCode = null;
        }
    }

    protected final void setEntityPropertyFillers(EntityPropertyFiller[] entityPropertyFillers) {
        assert (entityPropertyFillers != null) : "Unspecified EntityPropertyFiller";
        this.assertParseableValues(entityPropertyFillers);
        List<EntityPropertyFiller> list = Arrays.asList(entityPropertyFillers);
        this.newPropertyValues = this.createNewPropertyValuesMap(list);
        this.unmatchedValues = new TreeSet<IKey>(IKey.KEY_COMPARATOR);
        this.unmatchedValues.addAll((Collection<IKey>)this.newPropertyValues.keySet());
    }

    private TableMap<IKey, EntityPropertyFiller> createNewPropertyValuesMap(List<EntityPropertyFiller> list) {
        TableMap<IKey, EntityPropertyFiller> map;
        IKeyExtractor<IKey, EntityPropertyFiller> keyExtractor = this.createKeyExtractor();
        try {
            map = new TableMap<IKey, EntityPropertyFiller>(list, keyExtractor);
        }
        catch (TableMap.UniqueKeyViolationException e) {
            String keyDesc = ((IKey)e.getInvalidKey()).getUniqueDescription();
            throw UserFailureException.fromTemplate("Duplicated property value for '%s'. It should be specified only once.", keyDesc);
        }
        return map;
    }

    @Override
    public final boolean attemptToSetUntypedValue(IUntypedValueSetter setter, ICodeAndIDHolder codeAndIDHolder) {
        IKey key = this.tryTranslate(codeAndIDHolder);
        if (key == null) {
            return false;
        }
        String untypedValue = this.untypedDefaultValueOrNull;
        EntityPropertyFiller value = this.newPropertyValues.tryGet(key);
        if (value != null) {
            untypedValue = value.getPropertyValue();
            this.unmatchedValues.remove(key);
        }
        if (untypedValue == null) {
            return false;
        }
        Long vocabularyTermID = null;
        if (this.vocabularyTermsByCode != null) {
            vocabularyTermID = this.vocabularyTermsByCode.tryGet(untypedValue.toUpperCase()).getId();
            assert (this.vocabularyTermsByCode != null);
        }
        setter.setUntypedValue(untypedValue, vocabularyTermID);
        return true;
    }

    @Override
    public final Set<IKey> getUnmatchedValues() {
        return this.unmatchedValues;
    }

    protected abstract IKeyExtractor<IKey, EntityPropertyFiller> createKeyExtractor();

    protected abstract IKey tryTranslate(ICodeAndIDHolder var1);

    private final void assertParseableValues(EntityPropertyFiller[] fillers) {
        EntityDataType propertyDataType = EntityDataType.createFromSimple(this.propertyType.getType().getCode());
        String vocabularyCode = this.propertyType.getVocabularyCode();
        if (this.untypedDefaultValueOrNull != null) {
            this.assertParseable(this.untypedDefaultValueOrNull, propertyDataType, vocabularyCode);
        }
        EntityPropertyFiller[] entityPropertyFillerArray = fillers;
        int n = fillers.length;
        int n2 = 0;
        while (n2 < n) {
            EntityPropertyFiller filler = entityPropertyFillerArray[n2];
            this.assertParseable(filler.getPropertyValue(), propertyDataType, vocabularyCode);
            ++n2;
        }
    }

    private final void assertParseable(String propertyValue, EntityDataType propertyDataType, String vocabularyCode) {
        VocabularyTermDTO term;
        if (this.vocabularyTermsByCode != null && (term = this.vocabularyTermsByCode.tryGet(propertyValue.toUpperCase())) == null) {
            throw new UserFailureException("Value '" + propertyValue + "' not from the controlled vocabulary '" + vocabularyCode + "'.");
        }
        EntityPropertyValue.createFromUntyped(propertyValue, propertyDataType);
    }
}

