/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.business.bo;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.lims.server.business.Session;
import ch.systemsx.cisd.lims.server.business.bo.AbstractProcedureBusinessObject;
import ch.systemsx.cisd.lims.server.business.bo.IProcedureBO;
import ch.systemsx.cisd.lims.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.lims.server.dto.ProcedureDTO;
import ch.systemsx.cisd.lims.server.dto.ProcedureTypeDTO;
import java.util.List;
import org.springframework.dao.DataAccessException;

final class ProcedureBO
extends AbstractProcedureBusinessObject
implements IProcedureBO {
    private ProcedureDTO procedure;
    private boolean shouldBeSaved;

    public ProcedureBO(IDAOFactory daoFactory, Session session) {
        super(daoFactory, session);
    }

    public final ProcedureDTO getProcedure() {
        return this.procedure;
    }

    public final void loadByID(long procedureID) {
        this.procedure = this.getProcedureDAO().getProcedure(procedureID);
    }

    public final void loadByExperimentIDAndType(long experimentID, String procedureTypeCode) {
        List<ProcedureDTO> procedures = this.getProcedureDAO().listProcedures(experimentID);
        for (ProcedureDTO procedureDTO : procedures) {
            if (!procedureDTO.getProcedureType().getCode().equals(procedureTypeCode)) continue;
            assert (experimentID == procedureDTO.getExperimentID()) : "Procedure " + procedureDTO + " does not belong to experiment with ID " + experimentID;
            this.procedure = procedureDTO;
            return;
        }
    }

    public final void define(long experimentID, String procedureTypeCode) {
        this.procedure = new ProcedureDTO(experimentID);
        ProcedureTypeDTO procedureType = this.getProcedureTypeDAO().tryFindProcedureTypeByCode(procedureTypeCode);
        if (procedureType == null) {
            throw new UserFailureException("Unknown procedure type " + procedureTypeCode + ".");
        }
        this.procedure.setProcedureType(procedureType);
        this.shouldBeSaved = true;
    }

    public final void save() {
        if (this.shouldBeSaved) {
            assert (this.procedure != null) : "Can not save an undefined procedure.";
            try {
                this.getProcedureDAO().createProcedure(this.procedure);
            }
            catch (DataAccessException ex) {
                ProcedureBO.throwException(ex, String.format("Procedure of type '%s'", this.procedure.getProcedureType().getCode()));
            }
        }
    }
}

