/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.business.bo;

import ch.systemsx.cisd.common.collections.IKeyExtractor;
import ch.systemsx.cisd.common.collections.TableMap;
import ch.systemsx.cisd.lims.server.dto.IProcedureHolder;
import ch.systemsx.cisd.lims.server.dto.ProcedureDTO;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcedureFiller {
    private ProcedureFiller() {
    }

    static final void fillProcedureFor(Iterable<? extends IProcedureHolder> iterable, List<ProcedureDTO> procedures) {
        assert (iterable != null) : "Given iterable can not be null.";
        assert (procedures != null);
        if (procedures.size() == 0) {
            return;
        }
        TableMap<Long, ProcedureDTO> table = new TableMap<Long, ProcedureDTO>(procedures, new IKeyExtractor<Long, ProcedureDTO>(){

            @Override
            public final Long getKey(ProcedureDTO e) {
                return e.getId();
            }
        });
        for (IProcedureHolder iProcedureHolder : iterable) {
            ProcedureDTO procedure = iProcedureHolder.getProcedure();
            if (procedure != null) continue;
            Long procId = iProcedureHolder.getProcedureID();
            assert (procId != null);
            ProcedureDTO foundProcedure = table.tryGet(procId);
            assert (foundProcedure != null);
            iProcedureHolder.setProcedure(foundProcedure);
        }
    }
}

