/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.business.bo;

import ch.systemsx.cisd.common.collections.IKeyExtractor;
import ch.systemsx.cisd.common.collections.TableMap;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.utilities.BeanUtils;
import ch.systemsx.cisd.lims.base.properties.PropertyType;
import ch.systemsx.cisd.lims.server.business.Session;
import ch.systemsx.cisd.lims.server.business.bo.AbstractBusinessObject;
import ch.systemsx.cisd.lims.server.business.bo.IPropertyTypeTable;
import ch.systemsx.cisd.lims.server.business.bo.RegistratorFiller;
import ch.systemsx.cisd.lims.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.lims.server.dataaccess.IPropertyTypeDAO;
import ch.systemsx.cisd.lims.server.dto.DataTypeDTO;
import ch.systemsx.cisd.lims.server.dto.PropertyTypeDTO;
import ch.systemsx.cisd.lims.server.dto.VocabularyDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.springframework.dao.DataAccessException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PropertyTypeTable
extends AbstractBusinessObject
implements IPropertyTypeTable {
    static final String PROPERTY_TYPES_NOT_LOADED = "Property types do not have been loaded.";
    private PropertyTypesByCode propertyTypes;
    private DataTypesByCode dataTypes;
    private final List<String> duplicatePropertyTypes = new ArrayList<String>();
    private final List<PropertyTypeDTO> addedPropertyTypes = new ArrayList<PropertyTypeDTO>();

    PropertyTypeTable(IDAOFactory daoFactory, Session session) {
        super(daoFactory, session);
        this.dataTypes = new DataTypesByCode(this.getPropertyTypeDAO().listDataTypes());
    }

    @Override
    public final void add(PropertyType propertyType) {
        assert (propertyType != null) : "Unspecified property type.";
        assert (this.propertyTypes != null) : "Property types do not have been loaded.";
        String name = propertyType.getCode();
        if (this.propertyTypes.tryGet(name) != null) {
            this.duplicatePropertyTypes.add(name);
        } else {
            final DataTypeDTO dataType = this.getDataType(propertyType);
            Long vocabularyId = this.tryGetVocabularyIdForPropertyCreation(propertyType);
            PropertyTypeDTO propertyTypeDTO = new PropertyTypeDTO(this.findRegistratorID(), dataType.getId(), vocabularyId);
            BeanUtils.fillBean(PropertyTypeDTO.class, propertyTypeDTO, propertyType, new BeanUtils.Converter(){

                public final DataTypeDTO convertToType(PropertyType sourceBean) {
                    return dataType;
                }
            });
            this.addedPropertyTypes.add(propertyTypeDTO);
        }
    }

    private DataTypeDTO getDataType(PropertyType propertyType) {
        String typeCode = propertyType.getType();
        DataTypeDTO dataType = (DataTypeDTO)this.dataTypes.tryGet(typeCode);
        if (typeCode == null) {
            throw UserFailureException.fromTemplate("Unknown type code. Cannot create property type '%s'.", propertyType.getCode());
        }
        return dataType;
    }

    @Override
    public final List<String> getDuplicatePropertyTypes() {
        return Collections.unmodifiableList(this.duplicatePropertyTypes);
    }

    @Override
    public final void load() {
        this.propertyTypes = new PropertyTypesByCode(this.getPropertyTypeDAO().listPropertyTypes());
    }

    @Override
    public Iterator<PropertyTypeDTO> iterator() {
        return this.propertyTypes.iterator();
    }

    @Override
    public void enrichWithRegistrator() {
        RegistratorFiller.fillRegistratorsFor(this.propertyTypes, this.getPersonDAO());
    }

    @Override
    public final void save() throws UserFailureException {
        IPropertyTypeDAO propertyTypeDAO = this.getPropertyTypeDAO();
        for (PropertyTypeDTO propertyType : this.addedPropertyTypes) {
            try {
                propertyTypeDAO.createPropertyType(propertyType);
            }
            catch (DataAccessException ex) {
                PropertyTypeTable.throwException(ex, propertyType.getCode());
            }
        }
    }

    private Long tryGetVocabularyIdForPropertyCreation(PropertyType propertyType) {
        String vocabularyCode = propertyType.getVocabularyCode();
        if (vocabularyCode != null) {
            VocabularyDTO vocabulary = this.getVocabulary(propertyType, vocabularyCode);
            if (vocabulary.isManagedInternally()) {
                throw UserFailureException.fromTemplate("Cannot create property type '%s' using controlled vocabulary '%s', because it is internally managed.", propertyType.getCode(), vocabularyCode);
            }
            return vocabulary.getId();
        }
        return null;
    }

    private VocabularyDTO getVocabulary(PropertyType propertyType, String vocabularyCode) {
        VocabularyDTO vocabulary = this.getVocabularyDAO().tryFindByCode(vocabularyCode);
        if (vocabulary == null) {
            throw UserFailureException.fromTemplate("There is no vocabulary set with code '%s'. Cannot create property type '%s'.", vocabularyCode, propertyType.getCode());
        }
        return vocabulary;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DataTypesByCode
    extends TableMap<String, DataTypeDTO> {
        DataTypesByCode(Collection<DataTypeDTO> rows) {
            super(rows, new IKeyExtractor<String, DataTypeDTO>(){

                @Override
                public final String getKey(DataTypeDTO e) {
                    return e.getCode();
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PropertyTypesByCode
    extends TableMap<String, PropertyTypeDTO> {
        PropertyTypesByCode(Collection<PropertyTypeDTO> rows) {
            super(rows, new IKeyExtractor<String, PropertyTypeDTO>(){

                @Override
                public final String getKey(PropertyTypeDTO e) {
                    return e.getCode();
                }
            });
        }
    }
}

