/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.dataaccess.db;

public class CodeConverter {
    static final String USER_PROPERTY_PREFIX = "USER.";

    private CodeConverter() {
    }

    public static String tryToBusinessLayer(String codeFromDatabaseOrNull) {
        return CodeConverter.tryToBusinessLayer(codeFromDatabaseOrNull, false);
    }

    public static String tryToBusinessLayer(String codeFromDatabaseOrNull, boolean userNamespace) {
        if (userNamespace && codeFromDatabaseOrNull != null) {
            return USER_PROPERTY_PREFIX + codeFromDatabaseOrNull;
        }
        return codeFromDatabaseOrNull;
    }

    public static String tryToDatabase(String codeFromBusinessLayerOrNull) {
        if (codeFromBusinessLayerOrNull == null) {
            return null;
        }
        String upperCaseCode = codeFromBusinessLayerOrNull.toUpperCase();
        if (upperCaseCode.startsWith(USER_PROPERTY_PREFIX)) {
            return upperCaseCode.substring(USER_PROPERTY_PREFIX.length());
        }
        return upperCaseCode;
    }

    public static boolean isInternalNamespace(String codeFromBusinessLayerOrNull) {
        if (codeFromBusinessLayerOrNull == null) {
            return false;
        }
        return !codeFromBusinessLayerOrNull.toUpperCase().startsWith(USER_PROPERTY_PREFIX);
    }
}

