/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.dataaccess.db;

import ch.systemsx.cisd.common.db.DBTableRestrictions;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.springframework.dao.DataIntegrityViolationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBRestrictionChecker {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, DBRestrictionChecker.class);
    private final Map<String, DBTableRestrictions> tableRestrictionMap;

    public DBRestrictionChecker(Map<String, DBTableRestrictions> tableRestrictonMap) {
        this.tableRestrictionMap = tableRestrictonMap;
    }

    public void check(String tableName, String columnName, String value) throws DataIntegrityViolationException {
        DBTableRestrictions restrictions = this.tableRestrictionMap.get(tableName);
        assert (restrictions != null) : "Illegal table " + tableName;
        int maxLength = restrictions.getLength(columnName);
        this.checkNotNullConstraint(tableName, columnName, value, restrictions);
        if (value == null) {
            return;
        }
        Set<String> checkedConstraint = restrictions.tryGetCheckedConstaint(columnName);
        if (checkedConstraint != null && !checkedConstraint.contains(value)) {
            String msg = String.format("Value '%s' is not one of the allowed alternatives %s of column %s.%s.", value, this.toString(checkedConstraint), tableName, columnName);
            operationLog.warn("Violation of database constraints detected: " + msg);
            throw new DataIntegrityViolationException(msg);
        }
        if (value.length() > maxLength) {
            String msg = String.format("Value '%s' is longer than the maximum length %d of column %s.%s.", value, maxLength, tableName, columnName);
            operationLog.warn("Violation of database constraints detected: " + msg);
            throw new DataIntegrityViolationException(msg);
        }
    }

    public void check(String tableName, String columnName, Object value) throws DataIntegrityViolationException {
        DBTableRestrictions restrictions = this.tableRestrictionMap.get(tableName);
        assert (restrictions != null) : "Illegal table " + tableName;
        this.checkNotNullConstraint(tableName, columnName, value, restrictions);
    }

    private void checkNotNullConstraint(String tableName, String columnName, Object value, DBTableRestrictions restrictions) throws DataIntegrityViolationException {
        assert (restrictions != null);
        if (value == null) {
            if (restrictions.hasNotNullConstraint(columnName)) {
                String msg = String.format("Value 'NULL' not allowed for column %s.%s.", tableName, columnName);
                operationLog.warn("Violation of database constraints detected: " + msg);
                throw new DataIntegrityViolationException(msg);
            }
            return;
        }
    }

    private String toString(Set<String> alternatives) {
        StringBuilder builder = new StringBuilder();
        builder.append("{ ");
        for (String alternative : alternatives) {
            builder.append(alternative);
            builder.append(", ");
        }
        builder.setLength(builder.length() - 2);
        builder.append(" }");
        return builder.toString();
    }
}

