/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.dataaccess.db;

import ch.systemsx.cisd.common.db.ISequencerHandler;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.lims.server.dataaccess.IGroupDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.AbstractDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.CodeConverter;
import ch.systemsx.cisd.lims.server.dataaccess.db.DtoValidatorStore;
import ch.systemsx.cisd.lims.server.dto.GroupDTO;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class GroupDAO
extends AbstractDAO
implements IGroupDAO {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, GroupDAO.class);
    private static final ParameterizedRowMapper<GroupDTO> GROUP_ROW_MAPPER = new ParameterizedRowMapper<GroupDTO>(){

        public GroupDTO mapRow(ResultSet rs, int rowNum) throws SQLException {
            GroupDTO group = new GroupDTO();
            group.setId(rs.getLong("id"));
            group.setCode(CodeConverter.tryToBusinessLayer(rs.getString("code")));
            return group;
        }
    };

    GroupDAO(DataSource dataSource, DtoValidatorStore dtoValidatorStore, ISequencerHandler sequencerHandler) {
        super(dataSource, dtoValidatorStore, sequencerHandler);
    }

    @Override
    public final Long getGroupIdByCode(String groupCode) throws DataAccessException {
        assert (groupCode != null);
        return this.getSimpleJdbcTemplate().queryForLong("select id from groups where code = ?", new Object[]{CodeConverter.tryToDatabase(groupCode)});
    }

    @Override
    public final List<GroupDTO> listGroups() throws DataAccessException {
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        List list = template.query("select * from groups", GROUP_ROW_MAPPER, new Object[0]);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug("listGroups(): " + list.size() + " group(s) have been found.");
        }
        return list;
    }

    @Override
    public final GroupDTO getGroupById(long groupId) throws DataAccessException {
        return (GroupDTO)this.getSimpleJdbcTemplate().queryForObject("select id, code from groups where id = ?", GROUP_ROW_MAPPER, new Object[]{groupId});
    }

    @Override
    public final void createGroup(GroupDTO groupDTO) {
        this.validateDTO(groupDTO);
        String code = CodeConverter.tryToDatabase(groupDTO.getCode());
        long id = this.createID();
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        template.update("insert into groups (id, code) values (?,?)", new Object[]{id, code});
        groupDTO.setId(id);
    }

    private final long createID() {
        return this.getNextValueOf("GROUP_ID_SEQ");
    }
}

