/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.dataaccess.db;

import ch.systemsx.cisd.common.db.ISequencerHandler;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.lims.base.properties.EntityKind;
import ch.systemsx.cisd.lims.server.dataaccess.IMaterialDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.AbstractDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.CodeConverter;
import ch.systemsx.cisd.lims.server.dataaccess.db.DtoValidatorStore;
import ch.systemsx.cisd.lims.server.dataaccess.db.properties.EntityPropertyTableNames;
import ch.systemsx.cisd.lims.server.dataaccess.db.properties.EntityPropertyValueRowMapper;
import ch.systemsx.cisd.lims.server.dataaccess.db.properties.EntityWithPropertiesFetcher;
import ch.systemsx.cisd.lims.server.dto.EntityPropertyValueDTO;
import ch.systemsx.cisd.lims.server.dto.EntityTypeDTO;
import ch.systemsx.cisd.lims.server.dto.IEntityPropertiesHolderDTO;
import ch.systemsx.cisd.lims.server.dto.MaterialDTO;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MaterialDAO
extends AbstractDAO
implements IMaterialDAO {
    private static final String MATERIAL_ID_COLUMN = "m.id";
    private static final String SELECT = "select m.id as id , m.code, m.registration_timestamp, m.maty_id, m.pers_id_registerer, m.mate_id_inhibitor_of, maty.code as maty_code, maty.description as maty_description ";
    private static final String PROPERTY_TABLE_ALIAS = "props";
    private static final String PROPERTIES_SELECT_ITEMS = "props.mate_id, props.mtpt_id, props.value, props.pers_id_registerer, cvterms.code as cvterms_code, props.cvte_id ";
    private static final String PROPERTIES_SELECT = "select props.mate_id, props.mtpt_id, props.value, props.pers_id_registerer, cvterms.code as cvterms_code, props.cvte_id ";
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, MaterialDAO.class);
    private static final Logger operationExTrackingLog = LogFactory.getLogger(LogCategory.OPERATION, MaterialDAO.class);
    private static final String GENE_SYMBOL_PROPERTY_CODE = "GENE_SYMBOL";
    private static final ParameterizedRowMapper<MaterialDTO> MATERIAL_ROW_MAPPER = new ParameterizedRowMapper<MaterialDTO>(){

        public final MaterialDTO mapRow(ResultSet rs, int rowNum) throws SQLException {
            MaterialDTO result = new MaterialDTO(rs.getLong("pers_id_registerer"));
            EntityTypeDTO materialType = new EntityTypeDTO();
            materialType.setId(rs.getLong("maty_id"));
            materialType.setCode(CodeConverter.tryToBusinessLayer(rs.getString("maty_code")));
            materialType.setDescription(rs.getString("maty_description"));
            result.setMaterialType(materialType);
            result.setId(rs.getLong("id"));
            result.setCode(CodeConverter.tryToBusinessLayer(rs.getString("code")));
            result.setRegistrationDate(new Date(rs.getTimestamp("registration_timestamp").getTime()));
            long inhibitorId = rs.getLong("mate_id_inhibitor_of");
            result.setInhibitorOfID(rs.wasNull() ? null : Long.valueOf(inhibitorId));
            return result;
        }
    };
    private final EntityPropertyTableNames entityPropertyTableNames = EntityPropertyTableNames.resolve(EntityKind.MATERIAL);

    private static String addPropertiesStatement(String from, String where, boolean distinct) {
        String propsFrom = String.valueOf(from) + ", " + MaterialDAO.getPropertiesSqlFromStatement("material_properties");
        String propsWhere = String.valueOf(where) + " and " + MATERIAL_ID_COLUMN + " = props.mate_id";
        String select = String.valueOf(distinct ? "select distinct " : "select ") + PROPERTIES_SELECT_ITEMS;
        return String.valueOf(select) + propsFrom + propsWhere;
    }

    private static String getPropertiesSimpleStatement(String where) {
        String propsFrom = MaterialDAO.getPropertiesSqlFromStatement("material_properties");
        return "select props.mate_id, props.mtpt_id, props.value, props.pers_id_registerer, cvterms.code as cvterms_code, props.cvte_id  from " + propsFrom + where;
    }

    private static String getPropertiesSqlFromStatement(String entityPropertiesTable) {
        return String.valueOf(entityPropertiesTable) + " as " + PROPERTY_TABLE_ALIAS + " left outer join " + "controlled_vocabulary_terms" + " as cvterms on " + PROPERTY_TABLE_ALIAS + ".cvte_id = cvterms.id ";
    }

    public MaterialDAO(DataSource dataSource, DtoValidatorStore dtoValidatorStore, ISequencerHandler sequencerHandler) {
        super(dataSource, dtoValidatorStore, sequencerHandler);
    }

    private EntityWithPropertiesFetcher<MaterialDTO> createPropertiesOwnerDAO(String from, String where) {
        String entityStatement = SELECT + from + where;
        String propertiesStatement = MaterialDAO.addPropertiesStatement(from, where, false);
        return this.createPropertiesOwnerFromSelects(entityStatement, propertiesStatement);
    }

    private EntityWithPropertiesFetcher<MaterialDTO> createPropertiesOwnerFromSelects(String entityStatement, String propertiesStatement) {
        return new EntityWithPropertiesFetcher<MaterialDTO>(entityStatement, propertiesStatement, MATERIAL_ROW_MAPPER, this.entityPropertyTableNames, this.getSimpleJdbcTemplate());
    }

    private List<MaterialDTO> selectMaterials(String from, String where) {
        EntityWithPropertiesFetcher<MaterialDTO> propertiesOwnerDAO = this.createPropertiesOwnerDAO(from, where);
        return propertiesOwnerDAO.execute();
    }

    private MaterialDTO selectMaterial(String from, String where) {
        EntityWithPropertiesFetcher<MaterialDTO> propertiesOwnerDAO = this.createPropertiesOwnerDAO(from, where);
        return propertiesOwnerDAO.executeForObject();
    }

    @Override
    public final List<MaterialDTO> listMoleculesForGeneSymbol(String geneSymbol) throws DataAccessException {
        assert (geneSymbol != null);
        String where = "where m.maty_id = maty.id and mapr.mate_id = m.id and mapr.mtpt_id = mtpt.id and mtpt.prty_id = prty.id and mapr.value = '" + geneSymbol + "'" + " and prty.code = '" + GENE_SYMBOL_PROPERTY_CODE + "'";
        return this.selectMaterials("from materials m, material_types maty, material_properties mapr, material_type_property_types mtpt, property_types prty ", where);
    }

    @Override
    public final List<MaterialDTO> findInhibitorsForId(long materialId) throws DataAccessException {
        String where = "where m.maty_id = maty.id and m.mate_id_inhibitor_of = " + materialId;
        List<MaterialDTO> list = this.selectMaterials("from materials as m, material_types as maty ", where);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug(String.valueOf(list.size()) + " Inhibitor(s) for material id '" + materialId + "' have been found.");
        }
        return list;
    }

    @Override
    public final Long tryFindMaterialIdByCodeAndTypeCode(String materialCode, String materialTypeCodeOrNull) throws DataAccessException {
        assert (StringUtils.isNotBlank(materialCode)) : "Given material code can not be blank.";
        String mangledMaterialCode = CodeConverter.tryToDatabase(materialCode);
        String mangledMaterialTypeCodeOrNull = CodeConverter.tryToDatabase(materialTypeCodeOrNull);
        if (materialTypeCodeOrNull != null) {
            return this.tryFindId("select ma.id from materials as ma, material_types as maty where ma.maty_id = maty.id and ma.code = ? and maty.code = ?", mangledMaterialCode, mangledMaterialTypeCodeOrNull);
        }
        return this.tryFindId("select id from materials where code = ?", mangledMaterialCode);
    }

    @Override
    public final MaterialDTO getMaterialById(long materialId) throws DataAccessException {
        String where = "where m.id = " + materialId + " and m.maty_id = maty.id";
        return this.selectMaterial("from materials as m, material_types as maty ", where);
    }

    @Override
    public final List<MaterialDTO> listMaterials(String materialTypeCode) throws DataAccessException {
        assert (StringUtils.isNotBlank(materialTypeCode));
        String mangledMaterialTypeCode = CodeConverter.tryToDatabase(materialTypeCode);
        String where = "where maty.code = '" + mangledMaterialTypeCode + "' and m.maty_id = maty.id";
        List<MaterialDTO> list = this.selectMaterials("from materials as m, material_types as maty ", where);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug(String.valueOf(list.size()) + " Material(s) with material code '" + mangledMaterialTypeCode + "' have been found.");
        }
        return list;
    }

    @Override
    public final void createMaterial(MaterialDTO material) throws DataAccessException {
        assert (material != null) : "Missing material.";
        EntityTypeDTO materialType = material.getMaterialType();
        assert (materialType != null) : "Missing material type.";
        Long matyID = materialType.getId();
        assert (matyID != null) : "Missing material type id.";
        String code = material.getCode();
        assert (code != null) : "Missing code.";
        Long registratorID = material.getRegistratorID();
        assert (registratorID != null) : "Missing registrator ID.";
        this.validateDTO(material);
        long id = this.getNextValueOf("MATERIAL_ID_SEQ");
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        template.update("insert into materials (id, code, maty_id, pers_id_registerer, mate_id_inhibitor_of) values (?,?,?,?,?)", new Object[]{id, CodeConverter.tryToDatabase(code), matyID, registratorID, material.getInhibitorOfID()});
        material.setId(id);
        if (operationExTrackingLog.isInfoEnabled()) {
            operationExTrackingLog.info("ADD: material " + material);
        }
    }

    @Override
    public final List<IEntityPropertiesHolderDTO> listAllEntityProperties() throws DataAccessException {
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        String sql = MaterialDAO.getPropertiesSimpleStatement("");
        EntityPropertyValueRowMapper mapper = this.createEntityPropertyValueRowMapper();
        template.query(sql, (ParameterizedRowMapper)mapper, new Object[0]);
        return mapper.getEntityPropertiesHolders();
    }

    @Override
    public final List<EntityPropertyValueDTO> listEntityProperties(long entityId) throws DataAccessException {
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        String sql = MaterialDAO.getPropertiesSimpleStatement(" where mate_id = ?");
        EntityPropertyValueRowMapper mapper = this.createEntityPropertyValueRowMapper();
        List result = template.query(sql, (ParameterizedRowMapper)mapper, new Object[]{entityId});
        return result;
    }

    private EntityPropertyValueRowMapper createEntityPropertyValueRowMapper() {
        return new EntityPropertyValueRowMapper(this.entityPropertyTableNames);
    }
}

