/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.dataaccess.db;

import ch.systemsx.cisd.common.db.ISequenceNameMapper;
import ch.systemsx.cisd.common.db.ISequencerHandler;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.lims.server.dataaccess.IProjectDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.AbstractDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.CodeConverter;
import ch.systemsx.cisd.lims.server.dataaccess.db.DtoValidatorStore;
import ch.systemsx.cisd.lims.server.dto.GroupDTO;
import ch.systemsx.cisd.lims.server.dto.ProjectDTO;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ProjectDAO
extends AbstractDAO
implements IProjectDAO {
    private static final String SELECT_FOR_LISTING = "select p.id, p.code, p.grou_id, g.id as gid, g.code as gcode, (select count(*) from experiments where proj_id = p.id) as size from projects p, groups g where p.grou_id = g.id";
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, ProjectDAO.class);
    private static final ParameterizedRowMapper<ProjectDTO> PROJECT_ROW_MAPPER = new ParameterizedRowMapper<ProjectDTO>(){

        public ProjectDTO mapRow(ResultSet rs, int rowNum) throws SQLException {
            long groupId = rs.getLong("gid");
            ProjectDTO project = new ProjectDTO(groupId);
            project.setId(rs.getLong("id"));
            project.setCode(CodeConverter.tryToBusinessLayer(rs.getString("code")));
            project.setSize(rs.getInt("size"));
            GroupDTO group = new GroupDTO();
            group.setId(groupId);
            group.setCode(CodeConverter.tryToBusinessLayer(rs.getString("gcode")));
            project.setGroup(group);
            return project;
        }
    };
    private final ISequenceNameMapper sequenceNameMapper;

    ProjectDAO(DataSource dataSource, DtoValidatorStore dtoValidatorStore, ISequencerHandler sequencerHandler, ISequenceNameMapper sequenceNameMapper) {
        super(dataSource, dtoValidatorStore, sequencerHandler);
        this.sequenceNameMapper = sequenceNameMapper;
    }

    @Override
    public final Long tryFindProjectIdByCode(long groupId, String projectCode) {
        assert (projectCode != null) : "Given project code can not be null.";
        return this.tryFindId("select p.id from projects p, groups g where p.grou_id = g.id and p.grou_id = ? and p.code = ?", groupId, CodeConverter.tryToDatabase(projectCode));
    }

    @Override
    public final List<ProjectDTO> listProjects(Long groupId) throws DataAccessException {
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        String sql = SELECT_FOR_LISTING;
        if (groupId != null) {
            sql = String.valueOf(sql) + " and p.grou_id = ?";
        }
        List list = groupId != null ? template.query(sql, PROJECT_ROW_MAPPER, new Object[]{groupId}) : template.query(sql, PROJECT_ROW_MAPPER, new Object[0]);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug("listProjects(): " + list.size() + " project(s) have been found.");
        }
        return list;
    }

    @Override
    public final void createProject(ProjectDTO project) throws DataAccessException {
        assert (project != null) : "Missing project.";
        Long groupId = project.getGroupId();
        assert (groupId != null) : "Missing group id.";
        this.validateDTO(project);
        long id = this.getNextValueOf(this.sequenceNameMapper.getSequencerForTable("projects"));
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        template.update("insert into projects (id, code, grou_id) values (?,?,?)", new Object[]{id, CodeConverter.tryToDatabase(project.getCode()), groupId});
        project.setId(id);
    }

    @Override
    public final ProjectDTO getProject(long groupId, String projectCode) throws DataAccessException {
        assert (projectCode != null) : "Missing project code.";
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        return (ProjectDTO)template.queryForObject("select p.id, p.code, p.grou_id, g.id as gid, g.code as gcode, (select count(*) from experiments where proj_id = p.id) as size from projects p, groups g where p.grou_id = g.id and p.grou_id = ? and p.code = ?", PROJECT_ROW_MAPPER, new Object[]{groupId, CodeConverter.tryToDatabase(projectCode)});
    }
}

