/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.dataaccess.db;

import ch.systemsx.cisd.lims.server.dataaccess.db.CodeConverter;
import ch.systemsx.cisd.lims.server.dataaccess.db.InvalidationDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.PersonDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.SimpleSampleRowMapper;
import ch.systemsx.cisd.lims.server.dto.SampleDTO;
import java.sql.ResultSet;
import java.sql.SQLException;

class SampleRowMapper
extends SimpleSampleRowMapper {
    private static final String PARENT_SAMPLE_PREFIX = "parent";
    private static final String TOP_SAMPLE_PREFIX = "top";

    SampleRowMapper() {
    }

    private static final void fillTop(SampleDTO sample, ResultSet rs) throws SQLException {
        Long topId = sample.getTopID();
        if (topId != null) {
            sample.setTop(SampleRowMapper.createSample(rs, topId, TOP_SAMPLE_PREFIX));
        }
    }

    private static final void fillGeneratedBy(SampleDTO sample, ResultSet rs) throws SQLException {
        Long generatedFromId = sample.getGeneratedFromID();
        if (generatedFromId != null) {
            sample.setGeneratedFrom(SampleRowMapper.createSample(rs, generatedFromId, PARENT_SAMPLE_PREFIX));
        }
    }

    private static final SampleDTO createSample(ResultSet rs, long id, String prefix) throws SQLException {
        SampleDTO top = new SampleDTO(null);
        top.setId(id);
        top.setCode(CodeConverter.tryToBusinessLayer(rs.getString(String.valueOf(prefix) + "_code")));
        long invalidationId = rs.getLong(String.valueOf(prefix) + "_inva_id");
        if (!rs.wasNull()) {
            top.setInvalidationId(invalidationId);
        }
        top.setSampleType(SampleRowMapper.createSampleType(rs, String.valueOf(prefix) + "_"));
        return top;
    }

    public SampleDTO mapRow(ResultSet rs, int rowNum) throws SQLException {
        SampleDTO sample = super.mapRow(rs, rowNum);
        if (sample.getInvalidationId() != null) {
            sample.setInvalidation(InvalidationDAO.tryFillInvalidationFromResultSet(rs, true));
        }
        sample.setRegistrator(PersonDAO.fillPersonFromResultSet(rs));
        SampleRowMapper.fillTop(sample, rs);
        SampleRowMapper.fillGeneratedBy(sample, rs);
        return sample;
    }
}

