/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.dataaccess.db;

import ch.systemsx.cisd.lims.server.dataaccess.db.CodeConverter;
import ch.systemsx.cisd.lims.server.dto.SampleDTO;
import ch.systemsx.cisd.lims.server.dto.SampleTypeDTO;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SimpleSampleRowMapper
implements ParameterizedRowMapper<SampleDTO> {
    SimpleSampleRowMapper() {
    }

    protected static final SampleTypeDTO createSampleType(ResultSet rs, String prefix) throws SQLException {
        assert (prefix != null) : "Given prefix can not be null.";
        SampleTypeDTO type = new SampleTypeDTO();
        type.setId(new Long(rs.getLong(String.valueOf(prefix) + "tid")));
        type.setCode(CodeConverter.tryToBusinessLayer(rs.getString(String.valueOf(prefix) + "tcode")));
        type.setDescription(rs.getString(String.valueOf(prefix) + "tdescription"));
        return type;
    }

    public SampleDTO mapRow(ResultSet rs, int rowNum) throws SQLException {
        SampleDTO sample = new SampleDTO(rs.getLong("pers_id_registerer"));
        long invaId = rs.getLong("inva_id");
        if (!rs.wasNull()) {
            sample.setInvalidationId(invaId);
        }
        sample.setId(new Long(rs.getLong("id")));
        sample.setCode(CodeConverter.tryToBusinessLayer(rs.getString("code")));
        long controlLayoutId = rs.getLong("samp_id_control_layout");
        if (!rs.wasNull()) {
            sample.setControlLayout(controlLayoutId, rs.getString("control_layout_code"));
        }
        sample.setRegistrationDate(new Date(rs.getTimestamp("registration_timestamp").getTime()));
        sample.setSampleType(SimpleSampleRowMapper.createSampleType(rs, ""));
        long topId = rs.getLong("samp_id_top");
        if (!rs.wasNull()) {
            sample.setTopID(topId);
        }
        long generatedFromId = rs.getLong("samp_id_generated_from");
        if (!rs.wasNull()) {
            sample.setGeneratedFromID(generatedFromId);
        }
        return sample;
    }
}

