/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.dataaccess.db.properties;

import ch.systemsx.cisd.lims.server.dataaccess.db.CodeConverter;
import ch.systemsx.cisd.lims.server.dataaccess.db.properties.EntityPropertyTableNames;
import ch.systemsx.cisd.lims.server.dataaccess.db.properties.IEntityPropertiesGetter;
import ch.systemsx.cisd.lims.server.dto.EntityPropertyValueDTO;
import ch.systemsx.cisd.lims.server.dto.EntityTypeDTO;
import ch.systemsx.cisd.lims.server.dto.IEntityPropertiesHolderDTO;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EntityPropertyValueRowMapper
implements ParameterizedRowMapper<EntityPropertyValueDTO>,
IEntityPropertiesGetter {
    private final Map<Long, List<EntityPropertyValueDTO>> propertyValues;
    private final String entityFK;
    private final String entityPropertyTypeFK;

    public EntityPropertyValueRowMapper(EntityPropertyTableNames tableNames) {
        this(tableNames.getEntityIDForeignKeyName(), tableNames.getEntityPropertyTypeIDForeignKeyName());
    }

    private EntityPropertyValueRowMapper(String entityFK, String entityPropertyTypeFK) {
        this.entityFK = entityFK;
        this.entityPropertyTypeFK = entityPropertyTypeFK;
        this.propertyValues = new LinkedHashMap<Long, List<EntityPropertyValueDTO>>();
    }

    private void addToCache(long entityId, EntityPropertyValueDTO propertyValue) {
        List<EntityPropertyValueDTO> parentProperties = this.propertyValues.get(entityId);
        if (parentProperties == null) {
            parentProperties = new ArrayList<EntityPropertyValueDTO>();
            this.propertyValues.put(entityId, parentProperties);
        }
        parentProperties.add(propertyValue);
    }

    public final EntityPropertyValueDTO mapRow(ResultSet rs, int rowNum) throws SQLException {
        Long registererId = rs.getLong("pers_id_registerer");
        long entityPropertyTypeId = rs.getLong(this.entityPropertyTypeFK);
        long entityId = rs.getLong(this.entityFK);
        EntityPropertyValueDTO propertyValue = new EntityPropertyValueDTO(registererId, entityPropertyTypeId);
        String value = rs.getString("value");
        Long vocabularyTermId = EntityPropertyValueRowMapper.tryGetLong(rs, "cvte_id");
        if (vocabularyTermId != null) {
            assert (value == null);
            value = CodeConverter.tryToBusinessLayer(rs.getString("cvterms_code"));
        }
        propertyValue.setUntypedValue(value, vocabularyTermId);
        this.addToCache(entityId, propertyValue);
        return propertyValue;
    }

    private static Long tryGetLong(ResultSet rs, String name) throws SQLException {
        long value = rs.getLong(name);
        if (rs.wasNull()) {
            return null;
        }
        return value;
    }

    @Override
    public List<EntityPropertyValueDTO> tryGetPropertiesFor(long entityId) {
        return this.propertyValues.get(entityId);
    }

    public List<IEntityPropertiesHolderDTO> getEntityPropertiesHolders() {
        ArrayList<IEntityPropertiesHolderDTO> holders = new ArrayList<IEntityPropertiesHolderDTO>();
        Set<Long> entityIds = this.propertyValues.keySet();
        for (Long entityId : entityIds) {
            List<EntityPropertyValueDTO> properties = this.tryGetPropertiesFor(entityId);
            IEntityPropertiesHolderDTO holder = EntityPropertyValueRowMapper.createImmutablePropertyHolder(entityId, properties);
            holders.add(holder);
        }
        return holders;
    }

    private static IEntityPropertiesHolderDTO createImmutablePropertyHolder(final Long entityId, final List<EntityPropertyValueDTO> propertiesList) {
        return new IEntityPropertiesHolderDTO(){

            public long getEntityId() {
                return entityId;
            }

            public EntityPropertyValueDTO[] getProperties() {
                return propertiesList.toArray(new EntityPropertyValueDTO[propertiesList.size()]);
            }

            public void setProperties(EntityPropertyValueDTO[] properties) {
                throw new UnsupportedOperationException();
            }

            public EntityTypeDTO getEntityType() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

