/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.dto;

import ch.systemsx.cisd.common.utilities.AbstractHashable;
import ch.systemsx.cisd.lims.server.dto.IRegistratorHolder;
import ch.systemsx.cisd.lims.server.dto.IUntypedValueSetter;
import ch.systemsx.cisd.lims.server.dto.Id;
import ch.systemsx.cisd.lims.server.dto.PersonDTO;

public final class EntityPropertyValueDTO
extends AbstractHashable
implements IRegistratorHolder,
IUntypedValueSetter {
    private final Long registratorID;
    private String valueOrNull;
    private Long vocabularyTermIdOrNull;
    private final long entityPropertyTypeId;
    private PersonDTO registrator;
    public static final EntityPropertyValueDTO[] EMPTY_ARRAY = new EntityPropertyValueDTO[0];

    public EntityPropertyValueDTO(Long registratorID, long entityPropertyTypeId) {
        this.registratorID = registratorID;
        this.entityPropertyTypeId = entityPropertyTypeId;
    }

    public final String tryGetUntypedValue() {
        return this.valueOrNull;
    }

    public final long getEntityPropertyTypeId() {
        return this.entityPropertyTypeId;
    }

    public final void setUntypedValue(String valueOrNull, Long vocabularyTermIdOrNull) {
        assert (valueOrNull != null || vocabularyTermIdOrNull == null) : "Value from controlled vocabulary set cannot be null!";
        this.valueOrNull = valueOrNull;
        this.vocabularyTermIdOrNull = vocabularyTermIdOrNull;
    }

    public final PersonDTO getRegistrator() {
        return this.registrator;
    }

    public final Long getRegistratorID() {
        return this.registratorID;
    }

    public final void setRegistrator(PersonDTO registrator) {
        Id.getAndCheckID(registrator, this.registratorID);
        this.registrator = registrator;
    }

    public Long getVocabularyTermId() {
        return this.vocabularyTermIdOrNull;
    }
}

