/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.util;

import ch.systemsx.cisd.common.collections.IKeyExtractor;
import ch.systemsx.cisd.lims.server.business.bo.SampleCriteriaWithId;
import ch.systemsx.cisd.lims.server.dto.BaseExperimentDTO;
import ch.systemsx.cisd.lims.server.dto.EntityTypeDTO;
import ch.systemsx.cisd.lims.server.dto.IEntityPropertiesHolderDTO;
import ch.systemsx.cisd.lims.server.dto.Id;
import ch.systemsx.cisd.lims.server.dto.MaterialDTO;
import ch.systemsx.cisd.lims.server.dto.ProcedureDTO;
import ch.systemsx.cisd.lims.server.dto.ProjectDTO;
import ch.systemsx.cisd.lims.server.dto.PropertyTypeDTO;
import ch.systemsx.cisd.lims.server.dto.SampleDTO;
import ch.systemsx.cisd.lims.server.dto.VocabularyTermDTO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KeyExtractorFactory {
    private static final IKeyExtractor<Long, ProjectDTO> PROJECT_BY_ID_KEY_EXTRACTOR = KeyExtractorFactory.createIdKeyExtractor();
    private static final IKeyExtractor<Long, BaseExperimentDTO> BASE_EXPERIMENT_BY_ID_KEY_EXTRACTOR = KeyExtractorFactory.createIdKeyExtractor();
    private static final IKeyExtractor<Long, EntityTypeDTO> ENTITY_TYPE_BY_ID_KEY_EXTRACTOR = KeyExtractorFactory.createIdKeyExtractor();
    private static final IKeyExtractor<String, VocabularyTermDTO> VOCABULARY_TERM_BY_CODE_KEY_EXTRACTOR = new VocabularyTermByCode();
    private static final IKeyExtractor<Long, PropertyTypeDTO> PROPERTY_TYPE_BY_ID_KEY_EXTRACTOR = KeyExtractorFactory.createIdKeyExtractor();
    private static final IKeyExtractor<Long, MaterialDTO> MATERIAL_BY_ID_KEY_EXTRACTOR = KeyExtractorFactory.createIdKeyExtractor();
    private static final IKeyExtractor<Long, ProcedureDTO> PROCEDURE_BY_ID_KEY_EXTRACTOR = KeyExtractorFactory.createIdKeyExtractor();
    private static final IKeyExtractor<Long, SampleDTO> SAMPLE_BY_ID_KEY_EXTRACTOR = KeyExtractorFactory.createIdKeyExtractor();
    private static final IKeyExtractor<Long, SampleCriteriaWithId> SAMPLE_CRITERIA_WITH_ID_BY_ID_KEY_EXTRACTOR = new SampleCriteriaWithIdKeyExtractor();
    private static final IKeyExtractor<Long, IEntityPropertiesHolderDTO> ENTITY_PROPERTIES_HOLDER_KEY_EXTRACTOR = new EntityPropertiesHolderKeyExtraktor();

    private KeyExtractorFactory() {
    }

    public static final <T extends Id> IKeyExtractor<Long, T> createIdKeyExtractor() {
        return new IdKeyExtractor();
    }

    public static final IKeyExtractor<Long, ProjectDTO> getProjectByIdKeyExtractor() {
        return PROJECT_BY_ID_KEY_EXTRACTOR;
    }

    public static final IKeyExtractor<Long, MaterialDTO> getMaterialByIdKeyExtractor() {
        return MATERIAL_BY_ID_KEY_EXTRACTOR;
    }

    public static final IKeyExtractor<Long, BaseExperimentDTO> getBaseExperimentByIdKeyExtractor() {
        return BASE_EXPERIMENT_BY_ID_KEY_EXTRACTOR;
    }

    public static final IKeyExtractor<String, VocabularyTermDTO> getVocabularyTermByCodeKeyExtractor() {
        return VOCABULARY_TERM_BY_CODE_KEY_EXTRACTOR;
    }

    public static final IKeyExtractor<Long, EntityTypeDTO> getEntityTypeByIdKeyExtractor() {
        return ENTITY_TYPE_BY_ID_KEY_EXTRACTOR;
    }

    public static final IKeyExtractor<Long, ProcedureDTO> getProcedureByIdKeyExtractor() {
        return PROCEDURE_BY_ID_KEY_EXTRACTOR;
    }

    public static final IKeyExtractor<Long, PropertyTypeDTO> getPropertyTypeByIdKeyExtractor() {
        return PROPERTY_TYPE_BY_ID_KEY_EXTRACTOR;
    }

    public static final IKeyExtractor<Long, SampleDTO> getSampleByIdKeyExtractor() {
        return SAMPLE_BY_ID_KEY_EXTRACTOR;
    }

    public static final IKeyExtractor<Long, IEntityPropertiesHolderDTO> getEntityPropertiesHolderKeyExtractor() {
        return ENTITY_PROPERTIES_HOLDER_KEY_EXTRACTOR;
    }

    public static final IKeyExtractor<Long, SampleCriteriaWithId> getSampleCriteriaWithIdKeyExtractor() {
        return SAMPLE_CRITERIA_WITH_ID_BY_ID_KEY_EXTRACTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EntityPropertiesHolderKeyExtraktor
    implements IKeyExtractor<Long, IEntityPropertiesHolderDTO> {
        private EntityPropertiesHolderKeyExtraktor() {
        }

        @Override
        public final Long getKey(IEntityPropertiesHolderDTO e) {
            return e.getEntityId();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class IdKeyExtractor<T extends Id>
    implements IKeyExtractor<Long, T> {
        private IdKeyExtractor() {
        }

        @Override
        public final Long getKey(Id id) {
            return id.getId();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SampleCriteriaWithIdKeyExtractor
    implements IKeyExtractor<Long, SampleCriteriaWithId> {
        private SampleCriteriaWithIdKeyExtractor() {
        }

        @Override
        public final Long getKey(SampleCriteriaWithId e) {
            return e.getSampleId();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class VocabularyTermByCode
    implements IKeyExtractor<String, VocabularyTermDTO> {
        private VocabularyTermByCode() {
        }

        @Override
        public final String getKey(VocabularyTermDTO e) {
            return e.getCode();
        }
    }
}

