/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.workflow.imsb;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.lims.server.workflow.imsb.IPlateBarcodeGenerator;

final class BarcodeGenerator
implements IPlateBarcodeGenerator {
    private static BarcodeGenerator instance;

    private BarcodeGenerator() {
    }

    public static final synchronized BarcodeGenerator getInstance() {
        if (instance == null) {
            instance = new BarcodeGenerator();
        }
        return instance;
    }

    private static final void checkCellPlateCode(String cellPlateCode) {
        if (!cellPlateCode.startsWith("CP")) {
            throw UserFailureException.fromTemplate("Invalid cell plate barcode: '%s' does not start with 'CP'.", cellPlateCode);
        }
        if (cellPlateCode.length() < 7) {
            throw UserFailureException.fromTemplate("Invalid cell plate barcode: '%s' is too short.", cellPlateCode);
        }
    }

    public final String getMasterPlateBarcode(String cellPlateCode) {
        assert (cellPlateCode != null);
        BarcodeGenerator.checkCellPlateCode(cellPlateCode);
        return "MP" + cellPlateCode.substring(2, cellPlateCode.length() - 2);
    }

    public String getDilutionPlateBarcode(String cellPlateCode) {
        assert (cellPlateCode != null);
        BarcodeGenerator.checkCellPlateCode(cellPlateCode);
        return "DP" + cellPlateCode.substring(2, cellPlateCode.length() - 1);
    }
}

