/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.webclient.client.application;

import ch.systemsx.cisd.lims.webclient.client.dto.Experiment;
import ch.systemsx.cisd.lims.webclient.client.dto.Procedure;
import ch.systemsx.cisd.lims.webclient.client.dto.Sample;
import java.util.HashMap;
import java.util.Map;

public final class ExperimentSampleCache {
    private static final Map sampleCache = new HashMap();

    private ExperimentSampleCache() {
    }

    public static final void initCache(Experiment experiment) {
        assert (experiment != null) : "Given experiment can not be null.";
        sampleCache.clear();
        Procedure[] procedures = experiment.getProcedures();
        int i = 0;
        while (i < procedures.length) {
            Procedure procedure = procedures[i];
            ExperimentSampleCache.addSamples(procedure.getInputSamples());
            ExperimentSampleCache.addSamples(procedure.getResultSamples());
            ++i;
        }
    }

    private static final void addSamples(Sample[] samples) {
        Sample sample;
        int i = 0;
        while (i < samples.length) {
            sample = samples[i];
            sampleCache.put(sample.getCode(), sample);
            ++i;
        }
        i = 0;
        while (i < samples.length) {
            sample = samples[i];
            ExperimentSampleCache.addSample(sample.getTop());
            ExperimentSampleCache.addSample(sample.getGeneratedFrom());
            ++i;
        }
    }

    private static final void addSample(Sample sample) {
        if (sample == null) {
            return;
        }
        String sampleCode = sample.getCode();
        if (!sampleCache.containsKey(sampleCode)) {
            sampleCache.put(sampleCode, sample);
        }
    }

    public static final Sample getSample(String code) {
        return (Sample)sampleCache.get(code);
    }
}

