/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.webclient.client.application.model;

import ch.systemsx.cisd.lims.webclient.client.application.ColumnConfigs;
import ch.systemsx.cisd.lims.webclient.client.application.IMessageResources;
import ch.systemsx.cisd.lims.webclient.client.application.model.AbstractDataGridModel;
import ch.systemsx.cisd.lims.webclient.client.application.utils.PersonUtils;
import ch.systemsx.cisd.lims.webclient.client.dto.Sample;
import com.gwtext.client.data.DateFieldDef;
import com.gwtext.client.data.StringFieldDef;
import com.gwtext.client.widgets.grid.ColumnConfig;
import java.util.ArrayList;
import java.util.List;

public class InputSampleGridModel
extends AbstractDataGridModel {
    public static final String CODE = "code";
    static final String SAMPLE_TYPE = "sampleType";

    public InputSampleGridModel(IMessageResources messageResources) {
        super(messageResources);
    }

    protected ColumnConfig createCodeColumnConfig() {
        return this.createSortableColumnWithLinkConfig(CODE, this.messageResources.getSampleCodeLabel(), 100);
    }

    public List getData(Object[] data) {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        int i = 0;
        while (i < data.length) {
            Sample sample = (Sample)data[i];
            String registrator = PersonUtils.toString(sample.getRegistrator());
            Object[] objects = new Object[]{sample.getCode(), sample.getSampleType().getCode(), registrator, sample.getRegistrationDate()};
            list.add(objects);
            ++i;
        }
        return list;
    }

    public List getFieldDefs() {
        ArrayList<Object> fieldDefs = new ArrayList<Object>();
        fieldDefs.add(new StringFieldDef(CODE));
        fieldDefs.add(new StringFieldDef(SAMPLE_TYPE));
        fieldDefs.add(new StringFieldDef("registrator"));
        fieldDefs.add(new DateFieldDef("registrationDate"));
        return fieldDefs;
    }

    public List getColumnConfigs() {
        ArrayList<ColumnConfig> configs = new ArrayList<ColumnConfig>();
        configs.add(this.createCodeColumnConfig());
        configs.add(this.createSortableColumnConfig(SAMPLE_TYPE, this.messageResources.getSampleTypeLabel(), 120));
        configs.add(ColumnConfigs.createRegistratorColumnConfig(this.messageResources));
        configs.add(ColumnConfigs.createRegistrationDateColumnConfig(this.messageResources));
        return configs;
    }
}

