/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.webclient.client.application.ui;

import ch.systemsx.cisd.lims.webclient.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.lims.webclient.client.application.IMessageResources;
import ch.systemsx.cisd.lims.webclient.client.application.context.ViewContext;
import ch.systemsx.cisd.lims.webclient.client.dto.SessionContext;
import com.gwtext.client.core.EventObject;
import com.gwtext.client.core.Ext;
import com.gwtext.client.core.Position;
import com.gwtext.client.widgets.Button;
import com.gwtext.client.widgets.MessageBox;
import com.gwtext.client.widgets.event.ButtonListener;
import com.gwtext.client.widgets.event.ButtonListenerAdapter;
import com.gwtext.client.widgets.event.KeyListener;
import com.gwtext.client.widgets.form.Field;
import com.gwtext.client.widgets.form.Form;
import com.gwtext.client.widgets.form.FormConfig;
import com.gwtext.client.widgets.form.TextField;
import com.gwtext.client.widgets.form.TextFieldConfig;

public class LoginWidget
extends Form {
    private static final String ID_PREFIX = "LoginWidget-";
    private static final int FIELD_WIDTH = 175;
    private final ViewContext viewContext;
    private TextField usernameField;
    private TextField passwordField;
    private Button button;

    public LoginWidget(ViewContext viewContext) {
        super(Ext.generateId((String)ID_PREFIX), LoginWidget.createFormConfig());
        this.viewContext = viewContext;
        this.createLoginForm();
    }

    private final void createLoginForm() {
        IMessageResources messageResources = this.viewContext.getMessageResources();
        this.fieldset(messageResources.getLoginLegend());
        this.usernameField = this.createUsernameField();
        this.add((Field)this.usernameField);
        this.passwordField = this.createPasswordField();
        this.add((Field)this.passwordField);
        this.button = this.addButton(messageResources.getLoginButtonLabel());
        this.button.addButtonListener((ButtonListener)new ButtonListenerAdapter(){

            public final void onClick(Button but, EventObject e) {
                LoginWidget.this.submitForm();
            }
        });
        this.getEl().addKeyListener(13, new KeyListener(){

            public final void onKey(int key, EventObject e) {
                LoginWidget.this.submitForm();
            }
        });
        this.end();
        this.render();
    }

    private static final FormConfig createFormConfig() {
        FormConfig formConfig = new FormConfig();
        formConfig.setWidth(300);
        formConfig.setLabelAlign(Position.LEFT);
        formConfig.setButtonAlign(Position.RIGHT);
        formConfig.setLabelWidth(75);
        return formConfig;
    }

    private final TextField createPasswordField() {
        TextFieldConfig fieldConfig = new TextFieldConfig();
        fieldConfig.setFieldLabel(this.viewContext.getMessageResources().getLoginPasswordLabel());
        fieldConfig.setWidth(175);
        fieldConfig.setPassword(true);
        fieldConfig.setAllowBlank(false);
        fieldConfig.setValidateOnBlur(false);
        return new TextField(fieldConfig);
    }

    private final TextField createUsernameField() {
        TextFieldConfig fieldConfig = new TextFieldConfig();
        fieldConfig.setFieldLabel(this.viewContext.getMessageResources().getLoginUsernameLabel());
        fieldConfig.setWidth(175);
        fieldConfig.setAllowBlank(false);
        fieldConfig.setValidateOnBlur(false);
        return new TextField(fieldConfig);
    }

    public final TextField getPasswordField() {
        return this.passwordField;
    }

    public final TextField getUsernameField() {
        return this.usernameField;
    }

    public final Button getButton() {
        return this.button;
    }

    protected void submitForm() {
        if (this.usernameField.validate() & this.passwordField.validate()) {
            this.button.disable();
            String username = this.usernameField.getText();
            String password = this.passwordField.getText();
            this.viewContext.getLimService().login(username, password, new LoginAsyncCallBack());
        }
    }

    protected void loginSuccessful(SessionContext sessionContext) {
        this.viewContext.getViewModel().setSessionContext(sessionContext);
    }

    private final class LoginAsyncCallBack
    extends AbstractAsyncCallback {
        LoginAsyncCallBack() {
            super(LoginWidget.this.viewContext);
        }

        public final void onFailure(Throwable caught) {
            super.onFailure(caught);
            LoginWidget.this.getButton().enable();
        }

        public final void onSuccess(Object result) {
            if (result != null) {
                LoginWidget.this.loginSuccessful((SessionContext)result);
            } else {
                IMessageResources messageResources = LoginWidget.this.viewContext.getMessageResources();
                MessageBox.alert((String)messageResources.getMessageBoxWarningTitle(), (String)messageResources.getLoginFailedMessage());
                LoginWidget.this.getButton().enable();
            }
        }
    }
}

