/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.webclient.server;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.logging.LoggingContextHandler;
import ch.systemsx.cisd.common.utilities.BeanUtils;
import ch.systemsx.cisd.common.utilities.BuildAndEnvironmentInfo;
import ch.systemsx.cisd.lims.base.ExperimentPlatesFilter;
import ch.systemsx.cisd.lims.base.ListSet;
import ch.systemsx.cisd.lims.base.PlateDimension;
import ch.systemsx.cisd.lims.base.QueryRestriction;
import ch.systemsx.cisd.lims.base.SampleComponent;
import ch.systemsx.cisd.lims.base.SampleComponentsLayout;
import ch.systemsx.cisd.lims.base.masterplate.MasterPlateLoader;
import ch.systemsx.cisd.lims.base.server.IRequestContextProvider;
import ch.systemsx.cisd.lims.base.server.RequestContextProviderAdapter;
import ch.systemsx.cisd.lims.server.business.DomainModel;
import ch.systemsx.cisd.lims.server.business.IExperimentManager;
import ch.systemsx.cisd.lims.server.business.IPersonManager;
import ch.systemsx.cisd.lims.server.business.ISessionManager;
import ch.systemsx.cisd.lims.server.business.Session;
import ch.systemsx.cisd.lims.server.dataaccess.IGroupDAO;
import ch.systemsx.cisd.lims.server.dto.AbstractExperimentDTO;
import ch.systemsx.cisd.lims.server.dto.BaseExperimentDTO;
import ch.systemsx.cisd.lims.server.dto.ExternalDataDTO;
import ch.systemsx.cisd.lims.server.dto.PersonDTO;
import ch.systemsx.cisd.lims.webclient.client.ILIMSService;
import ch.systemsx.cisd.lims.webclient.client.InvalidSessionException;
import ch.systemsx.cisd.lims.webclient.client.dto.BaseExperiment;
import ch.systemsx.cisd.lims.webclient.client.dto.BuildInfo;
import ch.systemsx.cisd.lims.webclient.client.dto.Column;
import ch.systemsx.cisd.lims.webclient.client.dto.Experiment;
import ch.systemsx.cisd.lims.webclient.client.dto.ExperimentFileAttachment;
import ch.systemsx.cisd.lims.webclient.client.dto.ExperimentIdentifier;
import ch.systemsx.cisd.lims.webclient.client.dto.PlateWells;
import ch.systemsx.cisd.lims.webclient.client.dto.Project;
import ch.systemsx.cisd.lims.webclient.client.dto.ProjectComparator;
import ch.systemsx.cisd.lims.webclient.client.dto.Sample;
import ch.systemsx.cisd.lims.webclient.client.dto.SampleGeneration;
import ch.systemsx.cisd.lims.webclient.client.dto.SessionContext;
import ch.systemsx.cisd.lims.webclient.client.dto.SimpleEntityProperty;
import ch.systemsx.cisd.lims.webclient.client.dto.User;
import ch.systemsx.cisd.lims.webclient.client.dto.WellCoordinates;
import ch.systemsx.cisd.lims.webclient.server.LoggerUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.springframework.dao.EmptyResultDataAccessException;

public final class LIMSServiceImpl
implements ILIMSService {
    private final ISessionManager sessionManager;
    private final DomainModel domainModel;
    private final LoggingContextHandler loggingContextHandler;
    private final IRequestContextProvider requestContextProvider;
    private final String groupCode;
    private final String downloadServiceBaseURL;

    public LIMSServiceImpl(ISessionManager sessionManager, DomainModel domainModel, IRequestContextProvider requestContextProvider, String groupCode, String downloadServiceBaseURL) {
        this.requestContextProvider = requestContextProvider;
        this.downloadServiceBaseURL = downloadServiceBaseURL;
        this.loggingContextHandler = new LoggingContextHandler(new RequestContextProviderAdapter(requestContextProvider));
        this.sessionManager = sessionManager;
        this.domainModel = domainModel;
        this.groupCode = groupCode;
    }

    private final Session getSession() throws ch.systemsx.cisd.lims.webclient.client.UserFailureException {
        Session session = null;
        try {
            session = this.sessionManager.getSession(null);
            if (session == null) {
                throw new InvalidSessionException("You are not logged in. Please log in.");
            }
            this.loggingContextHandler.setMDC(session.getSessionToken());
            return session;
        }
        catch (UserFailureException ex) {
            if (session != null) {
                this.loggingContextHandler.destroyContext(session.getSessionToken());
            }
            throw new ch.systemsx.cisd.lims.webclient.client.UserFailureException(ex.getMessage());
        }
    }

    private static final void sortProjects(Project[] projects) {
        Arrays.sort(projects, new ProjectComparator());
    }

    private static ch.systemsx.cisd.lims.webclient.client.dto.SampleComponent[] convert(SampleComponent[] sampleComponents) {
        ch.systemsx.cisd.lims.webclient.client.dto.SampleComponent[] result = new ch.systemsx.cisd.lims.webclient.client.dto.SampleComponent[sampleComponents.length];
        int i = 0;
        while (i < sampleComponents.length) {
            result[i] = BeanUtils.createBean(ch.systemsx.cisd.lims.webclient.client.dto.SampleComponent.class, sampleComponents[i]);
            ++i;
        }
        return result;
    }

    private static final ch.systemsx.cisd.lims.base.ExperimentIdentifier convert(ExperimentIdentifier experimentIdentifier) {
        return BeanUtils.createBean(ch.systemsx.cisd.lims.base.ExperimentIdentifier.class, experimentIdentifier);
    }

    private final void ensureUserRegistered(Session session) {
        IPersonManager personManager = this.domainModel.getPersonManager();
        PersonDTO person = personManager.getPerson(session);
        if (person == null) {
            personManager.registerPerson(session);
        }
    }

    private Session tryAuthenticate(String user, String password, String groupCodeParameter) throws ch.systemsx.cisd.lims.webclient.client.UserFailureException {
        try {
            IGroupDAO dao = this.domainModel.getDAOFactory().getGroupDAO();
            String sessionToken = this.sessionManager.openSession(user, password, dao.getGroupById(dao.getGroupIdByCode(groupCodeParameter)));
            if (sessionToken != null) {
                Session session = this.sessionManager.getSession(sessionToken);
                this.loggingContextHandler.addContext(session.getSessionToken(), session.toString());
                this.ensureUserRegistered(session);
                return session;
            }
            return null;
        }
        catch (EmptyResultDataAccessException emptyResultDataAccessException) {
            throw new ch.systemsx.cisd.lims.webclient.client.UserFailureException(String.format("Given group code '%s' could not be found in the database.", groupCodeParameter));
        }
    }

    public final String getRemoteHost() {
        return this.requestContextProvider.getHttpServletRequest().getRemoteHost();
    }

    public final SessionContext login(String user, String password) throws ch.systemsx.cisd.lims.webclient.client.UserFailureException {
        SessionContext result = null;
        try {
            Session session = this.tryAuthenticate(user, password, this.groupCode);
            if (session != null) {
                result = this.createSessionContext(session);
            }
            return result;
        }
        catch (Exception e) {
            throw new ch.systemsx.cisd.lims.webclient.client.UserFailureException(e.getMessage());
        }
    }

    public final void logout() {
        try {
            Session session = this.getSession();
            if (session != null) {
                this.sessionManager.closeSession(null);
                this.loggingContextHandler.destroyContext(session.getSessionToken());
            }
        }
        catch (ch.systemsx.cisd.lims.webclient.client.UserFailureException userFailureException) {}
    }

    public final BaseExperiment[] listExperiments(String projectCode) throws ch.systemsx.cisd.lims.webclient.client.UserFailureException {
        Session session = this.getSession();
        boolean operationSuccessful = false;
        QueryRestriction queryRestriction = new QueryRestriction();
        try {
            IExperimentManager experimentManager = this.domainModel.getExperimentManager();
            queryRestriction.setProjectCode(projectCode);
            Object[] experiments = BeanUtils.createBeanList(BaseExperiment.class, (Iterable)Arrays.asList(experimentManager.listExperiments(session, queryRestriction)), BaseExperimentConverter.BASE_EXPERIMENT_INSTANCE).toArray(BaseExperiment.EMPTY_ARRAY);
            Arrays.sort(experiments);
            operationSuccessful = true;
            Object[] objectArray = experiments;
            return objectArray;
        }
        catch (Exception e) {
            throw new ch.systemsx.cisd.lims.webclient.client.UserFailureException(e.getMessage());
        }
        finally {
            LoggerUtils.logAccessUserBehaviour(LoggerUtils.createLogger(session, operationSuccessful).listExperiments(queryRestriction));
        }
    }

    public final Experiment getExperimentInfo(ExperimentIdentifier experimentIdentifier) throws ch.systemsx.cisd.lims.webclient.client.UserFailureException {
        Session session = this.getSession();
        boolean operationSuccessful = false;
        try {
            IExperimentManager experimentManager = this.domainModel.getExperimentManager();
            Experiment result = BeanUtils.createBean(Experiment.class, experimentManager.getExperimentInfoWithDatasets(session, LIMSServiceImpl.convert(experimentIdentifier), new ExperimentPlatesFilter(false)), ExperimentConverter.EXPERIMENT_INSTANCE);
            operationSuccessful = true;
            Experiment experiment = result;
            return experiment;
        }
        catch (UserFailureException ex) {
            throw new ch.systemsx.cisd.lims.webclient.client.UserFailureException(ex.getMessage());
        }
        finally {
            LoggerUtils.logAccessUserBehaviour(LoggerUtils.createLogger(session, operationSuccessful).getExperimentInfoWithDatasets(LIMSServiceImpl.convert(experimentIdentifier)));
        }
    }

    public final ExperimentFileAttachment getExperimentFileAttachment(ExperimentIdentifier experimentIdentifier, String fileName, int version) throws ch.systemsx.cisd.lims.webclient.client.UserFailureException {
        Session session = this.getSession();
        boolean operationSuccessful = false;
        try {
            ExperimentFileAttachment result = BeanUtils.createBean(ExperimentFileAttachment.class, this.domainModel.getExperimentManager().getExperimentFileAttachment(session, LIMSServiceImpl.convert(experimentIdentifier), fileName, version));
            operationSuccessful = true;
            ExperimentFileAttachment experimentFileAttachment = result;
            return experimentFileAttachment;
        }
        catch (UserFailureException e) {
            throw new ch.systemsx.cisd.lims.webclient.client.UserFailureException(e.getMessage());
        }
        finally {
            LoggerUtils.logAccessUserBehaviour(LoggerUtils.createLogger(session, operationSuccessful).getExperimentAttachment(LIMSServiceImpl.convert(experimentIdentifier), fileName, version));
        }
    }

    public final SessionContext tryGetCurrentSessionContext() {
        try {
            Session session = this.getSession();
            return this.createSessionContext(session);
        }
        catch (ch.systemsx.cisd.lims.webclient.client.UserFailureException userFailureException) {
            return null;
        }
    }

    private SessionContext createSessionContext(Session session) {
        SessionContext sessionContext = new SessionContext();
        sessionContext.setUser(BeanUtils.createBean(User.class, session));
        sessionContext.setSessionID(session.getSessionToken());
        sessionContext.setDownloadServiceBaseURL(this.downloadServiceBaseURL);
        return sessionContext;
    }

    public final Project[] listProjects() throws ch.systemsx.cisd.lims.webclient.client.UserFailureException {
        Session session = this.getSession();
        boolean operationSuccessful = false;
        try {
            Project[] projects = BeanUtils.createBeanList(Project.class, this.domainModel.getProjectManager().listProjects(session.getGroupId())).toArray(Project.EMPTY_ARRAY);
            LIMSServiceImpl.sortProjects(projects);
            operationSuccessful = true;
            Project[] projectArray = projects;
            return projectArray;
        }
        catch (UserFailureException ex) {
            throw new ch.systemsx.cisd.lims.webclient.client.UserFailureException(ex.getMessage());
        }
        finally {
            LoggerUtils.logAccessUserBehaviour(LoggerUtils.createLogger(session, operationSuccessful).listProjects());
        }
    }

    public final Sample[] listSamples(String sampleTypeCode) throws ch.systemsx.cisd.lims.webclient.client.UserFailureException {
        Session session = this.getSession();
        boolean operationSuccessful = false;
        boolean enrichWithRelations = false;
        try {
            Object[] samples = BeanUtils.createBeanList(Sample.class, (Iterable)Arrays.asList(this.domainModel.getSampleManager().listSamples(session, sampleTypeCode, null, null, enrichWithRelations)), BooleanOrUnknownConverter.BOOLEAN_OR_UNKNONW_INSTANCE).toArray(Sample.EMPTY_ARRAY);
            Arrays.sort(samples);
            operationSuccessful = true;
            Object[] objectArray = samples;
            return objectArray;
        }
        catch (UserFailureException e) {
            throw new ch.systemsx.cisd.lims.webclient.client.UserFailureException(e.getMessage());
        }
        finally {
            LoggerUtils.logAccessUserBehaviour(LoggerUtils.createLogger(session, operationSuccessful).listSamples(sampleTypeCode, null, null, enrichWithRelations));
        }
    }

    public final PlateWells getPlateWells(String sampleCode, boolean enrichMaterials) throws ch.systemsx.cisd.lims.webclient.client.UserFailureException {
        boolean operationSuccessful = false;
        try {
            SampleComponent[] components = this.getSampleMergedComponents(sampleCode, enrichMaterials);
            PlateDimension dim = this.domainModel.getSampleManager().getPlateDimension(this.getSession(), sampleCode);
            PlateWells result = LIMSServiceImpl.createWellsMatrix(LIMSServiceImpl.convert(components), dim.getRowsNum(), dim.getColsNum());
            operationSuccessful = true;
            PlateWells plateWells = result;
            return plateWells;
        }
        catch (UserFailureException e) {
            throw new ch.systemsx.cisd.lims.webclient.client.UserFailureException(e.getMessage());
        }
        finally {
            LoggerUtils.logAccessUserBehaviour(LoggerUtils.createLogger(this.getSession(), operationSuccessful).getSampleLayout(sampleCode));
        }
    }

    private static final PlateWells createWellsMatrix(ch.systemsx.cisd.lims.webclient.client.dto.SampleComponent[] components, int rows, int cols) {
        assert (components != null) : "Give plate wells can not be null.";
        ch.systemsx.cisd.lims.webclient.client.dto.SampleComponent[][] matrix = new ch.systemsx.cisd.lims.webclient.client.dto.SampleComponent[rows][cols];
        boolean isConsistent = true;
        int i = 0;
        while (i < components.length) {
            ch.systemsx.cisd.lims.webclient.client.dto.SampleComponent well = components[i];
            WellCoordinates wellCoordinates = well.getWellCoordinates();
            if (wellCoordinates != null) {
                int colIx = wellCoordinates.getColumnIndex();
                int rowIx = wellCoordinates.getRowIx();
                isConsistent = isConsistent && matrix[rowIx][colIx] == null;
                matrix[rowIx][colIx] = well;
            }
            ++i;
        }
        return new PlateWells(matrix, isConsistent, rows, cols);
    }

    public final SampleGeneration getSampleInfo(String sampleCode) throws ch.systemsx.cisd.lims.webclient.client.UserFailureException {
        Session session = this.getSession();
        boolean operationSuccessful = false;
        try {
            ch.systemsx.cisd.lims.base.SampleGeneration sampleInfo = this.domainModel.getSampleManager().getSampleInfo(session, sampleCode);
            SampleGeneration result = BeanUtils.createBean(SampleGeneration.class, sampleInfo, BooleanOrUnknownConverter.BOOLEAN_OR_UNKNONW_INSTANCE);
            operationSuccessful = true;
            SampleGeneration sampleGeneration = result;
            return sampleGeneration;
        }
        catch (UserFailureException ex) {
            throw new ch.systemsx.cisd.lims.webclient.client.UserFailureException(ex.getMessage());
        }
        finally {
            LoggerUtils.logAccessUserBehaviour(LoggerUtils.createLogger(session, operationSuccessful).getSampleInfo(sampleCode));
        }
    }

    public final Column[] getMasterPlate(String sampleCode) throws ch.systemsx.cisd.lims.webclient.client.UserFailureException {
        boolean operationSuccesful = false;
        try {
            Column[] result = this.renderMasterPlate(this.getSampleMergedComponents(sampleCode, true));
            operationSuccesful = true;
            Column[] columnArray = result;
            return columnArray;
        }
        catch (UserFailureException ex) {
            throw new ch.systemsx.cisd.lims.webclient.client.UserFailureException(ex.getMessage());
        }
        finally {
            LoggerUtils.logAccessUserBehaviour(LoggerUtils.createLogger(this.getSession(), operationSuccesful).getSampleLayout(sampleCode));
        }
    }

    private final SampleComponent[] getSampleMergedComponents(String sampleCode, boolean enrichMaterials) throws ch.systemsx.cisd.lims.webclient.client.UserFailureException {
        Session session = this.getSession();
        try {
            SampleComponentsLayout sampleMergedLayout = this.domainModel.getSampleManager().getSampleMergedLayout(session, sampleCode, enrichMaterials);
            return sampleMergedLayout.getComponents();
        }
        catch (UserFailureException e) {
            throw new ch.systemsx.cisd.lims.webclient.client.UserFailureException(e.getMessage());
        }
    }

    private final Column[] renderMasterPlate(SampleComponent[] components) {
        ListSet listSet = MasterPlateLoader.createTable(components, true);
        ArrayList<Column> columns = new ArrayList<Column>();
        for (String name : listSet.getNamesOfNonEmptyColumns()) {
            columns.add(this.getListAsColumn(listSet, name));
        }
        return columns.toArray(new Column[columns.size()]);
    }

    private final Column getListAsColumn(ListSet listSet, String listName) {
        List<String> list = listSet.tryGetList(listName);
        if (list == null) {
            throw new IllegalArgumentException(String.format("Unknown list '%s'.", listName));
        }
        String label = listSet.getLabel(listName);
        Column column = new Column(listName, label);
        column.setValues(list.toArray(ArrayUtils.EMPTY_STRING_ARRAY));
        return column;
    }

    public final BuildInfo getBuildInfo() {
        BuildAndEnvironmentInfo info = BuildAndEnvironmentInfo.INSTANCE;
        BuildInfo buildInfo = new BuildInfo();
        buildInfo.setCleanSources(info.isCleanSources());
        buildInfo.setRevision(info.getRevision());
        buildInfo.setVersion(info.getVersion());
        buildInfo.setDbVersion("018");
        return buildInfo;
    }

    private static class AbstractExperimentConverter
    implements BeanUtils.Converter {
        private AbstractExperimentConverter() {
        }

        public final SimpleEntityProperty[] convertToProperties(AbstractExperimentDTO entity) {
            return BeanUtils.createBeanArray(SimpleEntityProperty.class, entity.getSimpleProperties());
        }
    }

    private static final class BaseExperimentConverter
    extends AbstractExperimentConverter {
        static final BeanUtils.Converter BASE_EXPERIMENT_INSTANCE = new BaseExperimentConverter();

        private BaseExperimentConverter() {
        }

        public final boolean convertToInvalidated(BaseExperimentDTO experimentDTO) {
            return experimentDTO.getInvalidationId() != null;
        }
    }

    private static final class BooleanOrUnknownConverter
    implements BeanUtils.Converter {
        static final BooleanOrUnknownConverter BOOLEAN_OR_UNKNONW_INSTANCE = new BooleanOrUnknownConverter();

        private BooleanOrUnknownConverter() {
        }

        public final String convertToComplete(ExternalDataDTO externalData) {
            return externalData.getComplete().name();
        }
    }

    private static final class ExperimentConverter
    extends AbstractExperimentConverter {
        static final BeanUtils.Converter EXPERIMENT_INSTANCE = new ExperimentConverter();

        private ExperimentConverter() {
        }

        public final String convertToComplete(ExternalDataDTO externalData) {
            return externalData.getComplete().name();
        }
    }
}

