/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.webservice;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.utilities.BeanUtils;
import ch.systemsx.cisd.lims.base.BaseExperiment;
import ch.systemsx.cisd.lims.base.EntityPropertyFiller;
import ch.systemsx.cisd.lims.base.EntityType;
import ch.systemsx.cisd.lims.base.Experiment;
import ch.systemsx.cisd.lims.base.ExperimentFileAttachment;
import ch.systemsx.cisd.lims.base.ExperimentIdentifier;
import ch.systemsx.cisd.lims.base.ExperimentPlatesFilter;
import ch.systemsx.cisd.lims.base.ExperimentType;
import ch.systemsx.cisd.lims.base.ILIMSService;
import ch.systemsx.cisd.lims.base.LimitFilter;
import ch.systemsx.cisd.lims.base.Material;
import ch.systemsx.cisd.lims.base.MoleculeCriteria;
import ch.systemsx.cisd.lims.base.NewExperiment;
import ch.systemsx.cisd.lims.base.NewSample;
import ch.systemsx.cisd.lims.base.NewSampleComponent;
import ch.systemsx.cisd.lims.base.NewSampleComponentWithFixedMaterialType;
import ch.systemsx.cisd.lims.base.Person;
import ch.systemsx.cisd.lims.base.PlainMaterial;
import ch.systemsx.cisd.lims.base.PlateDimension;
import ch.systemsx.cisd.lims.base.PlateLocation;
import ch.systemsx.cisd.lims.base.Project;
import ch.systemsx.cisd.lims.base.PropertyTypeEntityTypeRelation;
import ch.systemsx.cisd.lims.base.QueryRestriction;
import ch.systemsx.cisd.lims.base.Sample;
import ch.systemsx.cisd.lims.base.SampleComponentsLayout;
import ch.systemsx.cisd.lims.base.SampleCriteria;
import ch.systemsx.cisd.lims.base.SampleFilter;
import ch.systemsx.cisd.lims.base.SampleGeneration;
import ch.systemsx.cisd.lims.base.SampleType;
import ch.systemsx.cisd.lims.base.SampleTypeCode;
import ch.systemsx.cisd.lims.base.Vocabulary;
import ch.systemsx.cisd.lims.base.VocabularyTerm;
import ch.systemsx.cisd.lims.base.properties.EntityKind;
import ch.systemsx.cisd.lims.base.properties.PropertyType;
import ch.systemsx.cisd.lims.base.properties.SimpleEntityProperty;
import ch.systemsx.cisd.lims.base.properties.SimpleEntityPropertySchema;
import ch.systemsx.cisd.lims.base.server.IRequestContextProvider;
import ch.systemsx.cisd.lims.server.business.BeanUtilsConverters;
import ch.systemsx.cisd.lims.server.business.DomainModel;
import ch.systemsx.cisd.lims.server.business.IEntityPropertyManager;
import ch.systemsx.cisd.lims.server.business.IExperimentManager;
import ch.systemsx.cisd.lims.server.business.ISampleManager;
import ch.systemsx.cisd.lims.server.business.ISessionManager;
import ch.systemsx.cisd.lims.server.business.Session;
import ch.systemsx.cisd.lims.server.dto.AbstractExperimentDTO;
import ch.systemsx.cisd.lims.server.dto.BaseExperimentDTO;
import ch.systemsx.cisd.lims.server.dto.ExperimentFileAttachmentDTO;
import ch.systemsx.cisd.lims.server.dto.ProjectDTO;
import ch.systemsx.cisd.lims.server.dto.SampleTypeDTO;
import ch.systemsx.cisd.lims.webservice.AbstractLIMSService;
import ch.systemsx.cisd.lims.webservice.IAccessController;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class LIMSService
extends AbstractLIMSService
implements ILIMSService {
    private static final String CONTROL_MATERIAL_TYPE_CODE = "CONTROL";

    public LIMSService(ISessionManager sessionManager, IRequestContextProvider requestContextProvider, IAccessController accessController, DomainModel domainModel, String groupCode) {
        super(sessionManager, requestContextProvider, accessController, domainModel, groupCode);
    }

    public final Void registerExperiments(String sessionToken, NewExperiment[] experimentsToRegister) throws UserFailureException {
        boolean operationSuccessful = false;
        try {
            this.checkAccess(sessionToken);
            Session session = this.getSession(sessionToken);
            this.domainModel.getExperimentManager().registerExperiments(session, experimentsToRegister);
            operationSuccessful = true;
            return null;
        }
        finally {
            this.logTrackingUserBehaviour(this.createLogger(sessionToken, operationSuccessful).registerExperiments(experimentsToRegister));
        }
    }

    public final Void addExperimentFileAttachment(String sessionToken, ExperimentIdentifier experimentIdentifier, ExperimentFileAttachment attachment) throws UserFailureException {
        boolean operationSuccessful = false;
        try {
            this.checkAccess(sessionToken);
            Session session = this.getSession(sessionToken);
            this.domainModel.getExperimentManager().addExperimentFileAttachment(session, experimentIdentifier, attachment);
            operationSuccessful = true;
            return null;
        }
        finally {
            this.logTrackingUserBehaviour(this.createLogger(sessionToken, operationSuccessful).addExperimentAttachment(experimentIdentifier, attachment));
        }
    }

    public final BaseExperiment[] listExperiments(String sessionToken, QueryRestriction queryRestriction) throws UserFailureException {
        boolean operationSuccessful = false;
        try {
            this.checkAccess(sessionToken);
            IExperimentManager experimentManager = this.domainModel.getExperimentManager();
            BaseExperiment[] experiments = BeanUtils.createBeanArray(BaseExperiment.class, experimentManager.listExperiments(this.getSession(sessionToken), queryRestriction), BaseExperimentConverter.BASE_EXPERIMENT_INSTANCE);
            operationSuccessful = true;
            BaseExperiment[] baseExperimentArray = experiments;
            return baseExperimentArray;
        }
        finally {
            this.logAccessUserBehaviour(this.createLogger(sessionToken, operationSuccessful).listExperiments(queryRestriction));
        }
    }

    public final Experiment getExperimentInfoBasic(String sessionToken, ExperimentIdentifier experimentIdentifier) throws UserFailureException {
        boolean operationSuccessful = false;
        try {
            this.checkAccess(sessionToken);
            Session session = this.getSession(sessionToken);
            Experiment result = BeanUtils.createBean(Experiment.class, this.domainModel.getExperimentManager().getExperimentInfoBasic(session, experimentIdentifier), AbstractExperimentConverter.ABSTRACT_EXPERIMENT_INSTANCE);
            operationSuccessful = true;
            Experiment experiment = result;
            return experiment;
        }
        finally {
            this.logAccessUserBehaviour(this.createLogger(sessionToken, operationSuccessful).getExperimentInfoBasic(experimentIdentifier));
        }
    }

    public final Experiment getExperimentInfoWithDatasets(String sessionToken, ExperimentIdentifier experimentIdentifier, ExperimentPlatesFilter filter) throws UserFailureException {
        boolean operationSuccessful = false;
        try {
            this.checkAccess(sessionToken);
            Session session = this.getSession(sessionToken);
            Experiment result = BeanUtils.createBean(Experiment.class, this.domainModel.getExperimentManager().getExperimentInfoWithDatasets(session, experimentIdentifier, filter), AbstractExperimentConverter.ABSTRACT_EXPERIMENT_INSTANCE);
            operationSuccessful = true;
            Experiment experiment = result;
            return experiment;
        }
        finally {
            this.logAccessUserBehaviour(this.createLogger(sessionToken, operationSuccessful).getExperimentInfoWithDatasets(experimentIdentifier));
        }
    }

    public final Experiment getExperimentInfoWithPlates(String sessionToken, ExperimentIdentifier experimentIdentifier, ExperimentPlatesFilter filter) throws UserFailureException {
        boolean operationSuccessful = false;
        try {
            this.checkAccess(sessionToken);
            Session session = this.getSession(sessionToken);
            Experiment result = BeanUtils.createBean(Experiment.class, this.domainModel.getExperimentManager().getExperimentInfoWithPlates(session, experimentIdentifier, filter), AbstractExperimentConverter.ABSTRACT_EXPERIMENT_INSTANCE);
            operationSuccessful = true;
            Experiment experiment = result;
            return experiment;
        }
        finally {
            this.logAccessUserBehaviour(this.createLogger(sessionToken, operationSuccessful).getExperimentInfoWithPlates(experimentIdentifier, filter));
        }
    }

    public final ExperimentFileAttachment getExperimentFileProperty(String sessionToken, ExperimentIdentifier experimentIdentifier, String filename, int version) throws UserFailureException {
        boolean operationSuccessful = false;
        try {
            this.checkAccess(sessionToken);
            Session session = this.getSession(sessionToken);
            IExperimentManager experimentManager = this.domainModel.getExperimentManager();
            ExperimentFileAttachmentDTO propertyDTO = experimentManager.getExperimentFileAttachment(session, experimentIdentifier, filename, version);
            ExperimentFileAttachment result = BeanUtils.createBean(ExperimentFileAttachment.class, propertyDTO, BeanUtilsConverters.getFilePropertyStringConverter());
            operationSuccessful = true;
            ExperimentFileAttachment experimentFileAttachment = result;
            return experimentFileAttachment;
        }
        finally {
            this.logAccessUserBehaviour(this.createLogger(sessionToken, operationSuccessful).getExperimentAttachment(experimentIdentifier, filename, version));
        }
    }

    public ExperimentType[] listExperimentTypes(String sessionToken) throws UserFailureException {
        boolean operationSuccessful = false;
        try {
            this.checkAccess(sessionToken);
            ExperimentType[] result = this.domainModel.getExperimentManager().listExperimentTypes();
            operationSuccessful = true;
            ExperimentType[] experimentTypeArray = result;
            return experimentTypeArray;
        }
        finally {
            this.logAccessUserBehaviour(this.createLogger(sessionToken, operationSuccessful).listExperimentTypes());
        }
    }

    public final EntityType[] listMaterialTypes(String sessionToken) {
        boolean operationSuccessful = false;
        try {
            this.checkAccess(sessionToken);
            EntityType[] result = this.domainModel.getMaterialManager().listMaterialTypes();
            operationSuccessful = true;
            EntityType[] entityTypeArray = result;
            return entityTypeArray;
        }
        finally {
            this.logAccessUserBehaviour(this.createLogger(sessionToken, operationSuccessful).listMaterialTypes());
        }
    }

    public final PlainMaterial[] listMaterials(String sessionToken, String materialTypeCode, String[] codePatterns, LimitFilter limitFilter) {
        boolean operationSuccessful = false;
        try {
            this.checkAccess(sessionToken);
            Session session = this.getSession(sessionToken);
            PlainMaterial[] result = this.domainModel.getMaterialManager().listMaterials(session, materialTypeCode, codePatterns, limitFilter);
            operationSuccessful = true;
            PlainMaterial[] plainMaterialArray = result;
            return plainMaterialArray;
        }
        finally {
            this.logAccessUserBehaviour(this.createLogger(sessionToken, operationSuccessful).listMaterials(materialTypeCode, codePatterns, limitFilter));
        }
    }

    public final Void registerMaterials(String sessionToken, Material[] materials, String materialTypeCode) throws UserFailureException {
        boolean operationSuccessful = false;
        try {
            this.checkAccess(sessionToken);
            Session session = this.getSession(sessionToken);
            this.domainModel.getMaterialManager().registerMaterials(session, materials, materialTypeCode);
            operationSuccessful = true;
            return null;
        }
        finally {
            this.logTrackingUserBehaviour(this.createLogger(sessionToken, operationSuccessful).registerMaterials(materials, materialTypeCode));
        }
    }

    public final Person[] listContacts(String sessionToken) {
        boolean operationSuccessful = false;
        try {
            this.checkAccess(sessionToken);
            Person[] result = BeanUtils.createBeanList(Person.class, this.domainModel.getPersonManager().listPersons()).toArray(new Person[0]);
            operationSuccessful = true;
            Person[] personArray = result;
            return personArray;
        }
        finally {
            this.logAccessUserBehaviour(this.createLogger(sessionToken, operationSuccessful).listContacts());
        }
    }

    public final Sample[] listSamples(String sessionToken, String sampleTypeCode, SampleFilter filter, LimitFilter limitFilter, boolean enrichWithRelations) throws UserFailureException {
        boolean operationSuccessful = false;
        try {
            this.checkAccess(sessionToken);
            Sample[] result = this.domainModel.getSampleManager().listSamples(this.getSession(sessionToken), sampleTypeCode, filter, limitFilter, enrichWithRelations);
            operationSuccessful = true;
            Sample[] sampleArray = result;
            return sampleArray;
        }
        finally {
            this.logAccessUserBehaviour(this.createLogger(sessionToken, operationSuccessful).listSamples(sampleTypeCode, filter, limitFilter, enrichWithRelations));
        }
    }

    public final PlateLocation[] getPlateLocations(String sessionToken, ExperimentIdentifier experimentIdentifier, MoleculeCriteria criteria, boolean showInvalidated) throws UserFailureException {
        boolean operationSuccessful = false;
        try {
            this.checkAccess(sessionToken);
            ISampleManager sampleManager = this.domainModel.getSampleManager();
            PlateLocation[] result = sampleManager.getPlateLocations(this.getSession(sessionToken), experimentIdentifier, criteria, showInvalidated);
            operationSuccessful = true;
            PlateLocation[] plateLocationArray = result;
            return plateLocationArray;
        }
        finally {
            this.logAccessUserBehaviour(this.createLogger(sessionToken, operationSuccessful).getPlateLocations(experimentIdentifier, criteria, showInvalidated));
        }
    }

    public final PlateDimension getPlateDimension(String sessionToken, String sampleCode) {
        boolean operationSuccessful = false;
        try {
            this.checkAccess(sessionToken);
            ISampleManager sampleManager = this.domainModel.getSampleManager();
            PlateDimension result = sampleManager.getPlateDimension(this.getSession(sessionToken), sampleCode);
            operationSuccessful = true;
            PlateDimension plateDimension = result;
            return plateDimension;
        }
        finally {
            this.logAccessUserBehaviour(this.createLogger(sessionToken, operationSuccessful).getPlateDimension(sampleCode));
        }
    }

    public Void registerControlLayout(String sessionToken, String sampleCode, SimpleEntityProperty[] properties, NewSampleComponentWithFixedMaterialType[] sampleComponents) throws UserFailureException {
        boolean operationSuccessful = false;
        try {
            NewSampleComponent[] completeSampleComponents;
            this.checkAccess(sessionToken);
            Session session = this.getSession(sessionToken);
            SampleCriteria sampleCriteria = LIMSService.createSampleCriteria(sampleCode, SampleTypeCode.CONTROL_LAYOUT);
            NewSample sample = new NewSample(sampleCriteria, null);
            sample.setProperties(properties);
            NewSampleComponent[] newSampleComponentArray = completeSampleComponents = BeanUtils.createBeanArray(NewSampleComponent.class, (Collection)Arrays.asList(sampleComponents), null);
            int n = completeSampleComponents.length;
            int n2 = 0;
            while (n2 < n) {
                NewSampleComponent c = newSampleComponentArray[n2];
                c.setMaterialTypeCode(CONTROL_MATERIAL_TYPE_CODE);
                ++n2;
            }
            this.domainModel.getSampleManager().registerSampleWithComponents(session, sample, completeSampleComponents, null);
            operationSuccessful = true;
            return null;
        }
        finally {
            this.logTrackingUserBehaviour(this.createLogger(sessionToken, operationSuccessful).registerControlLayout(sampleCode, sampleComponents));
        }
    }

    public Void registerMasterPlate(String sessionToken, String sampleCode, SimpleEntityProperty[] properties, NewSampleComponent[] sampleComponents, String materialBatchCode, String controlLayoutCodeOrNull) throws UserFailureException {
        boolean operationSuccessful = false;
        try {
            this.checkAccess(sessionToken);
            Session session = this.getSession(sessionToken);
            SampleCriteria sampleCriteria = LIMSService.createSampleCriteria(sampleCode, SampleTypeCode.MASTER_PLATE);
            NewSample sample = new NewSample(sampleCriteria, controlLayoutCodeOrNull);
            sample.setProperties(properties);
            this.domainModel.getSampleManager().registerSampleWithComponents(session, sample, sampleComponents, materialBatchCode);
            operationSuccessful = true;
            return null;
        }
        finally {
            this.logTrackingUserBehaviour(this.createLogger(sessionToken, operationSuccessful).registerMasterPlate(sampleCode, sampleComponents, materialBatchCode, controlLayoutCodeOrNull));
        }
    }

    private static SampleCriteria createSampleCriteria(String code, SampleTypeCode sampleTypeCode) {
        SampleCriteria criteria = new SampleCriteria();
        criteria.setSampleCode(code);
        criteria.setSampleTypeCode(sampleTypeCode.getCode());
        return criteria;
    }

    public final Project[] listProjects(String sessionToken) {
        boolean operationSuccessful = false;
        try {
            this.checkAccess(sessionToken);
            List<ProjectDTO> projects = this.domainModel.getProjectManager().listProjects(this.getSession(sessionToken).getGroupId());
            Project[] result = BeanUtils.createBeanList(Project.class, projects).toArray(new Project[projects.size()]);
            operationSuccessful = true;
            Project[] projectArray = result;
            return projectArray;
        }
        finally {
            this.logAccessUserBehaviour(this.createLogger(sessionToken, operationSuccessful).listProjects());
        }
    }

    public Vocabulary[] listVocabularies(String sessionToken) {
        boolean operationSuccessful = false;
        try {
            this.checkAccess(sessionToken);
            List<Vocabulary> listVocabularies = this.domainModel.getPropertyTypeManager().listVocabularies(this.getSession(sessionToken));
            Vocabulary[] result = listVocabularies.toArray(new Vocabulary[listVocabularies.size()]);
            operationSuccessful = true;
            Vocabulary[] vocabularyArray = result;
            return vocabularyArray;
        }
        finally {
            this.logAccessUserBehaviour(this.createLogger(sessionToken, operationSuccessful).listVocabularies());
        }
    }

    public VocabularyTerm[] listVocabularyTerms(String sessionToken, String vocabularyCode) {
        boolean operationSuccessful = false;
        try {
            this.checkAccess(sessionToken);
            List<VocabularyTerm> listVocabularyTerms = this.domainModel.getPropertyTypeManager().listVocabularyTerms(this.getSession(sessionToken), vocabularyCode);
            VocabularyTerm[] result = listVocabularyTerms.toArray(new VocabularyTerm[listVocabularyTerms.size()]);
            operationSuccessful = true;
            VocabularyTerm[] vocabularyTermArray = result;
            return vocabularyTermArray;
        }
        finally {
            this.logAccessUserBehaviour(this.createLogger(sessionToken, operationSuccessful).listVocabularyTerms(vocabularyCode));
        }
    }

    public final Void registerProject(String sessionToken, String projectCode) {
        boolean operationSuccessful = false;
        try {
            this.checkAccess(sessionToken);
            this.domainModel.getProjectManager().registerProject(this.getSession(sessionToken), projectCode);
            operationSuccessful = true;
            return null;
        }
        finally {
            this.logTrackingUserBehaviour(this.createLogger(sessionToken, operationSuccessful).registerProject(projectCode));
        }
    }

    public final Void registerSamples(String sessionToken, NewSample[] samples) {
        boolean operationSuccessful = false;
        try {
            this.checkAccess(sessionToken);
            this.domainModel.getSampleManager().registerSamples(this.getSession(sessionToken), samples);
            operationSuccessful = true;
            return null;
        }
        finally {
            this.logTrackingUserBehaviour(this.createLogger(sessionToken, operationSuccessful).registerSamples(samples));
        }
    }

    public final Void registerPropertyTypes(String sessionToken, PropertyType[] properties) throws UserFailureException {
        boolean operationSuccessful = false;
        try {
            this.checkAccess(sessionToken);
            this.domainModel.getPropertyTypeManager().registerPropertyTypes(this.getSession(sessionToken), properties);
            operationSuccessful = true;
            return null;
        }
        finally {
            this.logTrackingUserBehaviour(this.createLogger(sessionToken, operationSuccessful).registerPropertyTypes(properties));
        }
    }

    public final PropertyTypeEntityTypeRelation[] listPropertyTypeRelations(String sessionToken, EntityKind entityKind) {
        boolean operationSuccessful = false;
        try {
            this.checkAccess(sessionToken);
            IEntityPropertyManager entityPropertyManager = this.domainModel.getEntityPropertyManager();
            PropertyTypeEntityTypeRelation[] result = entityPropertyManager.listPropertyTypeEntityTypeRelations(this.getSession(sessionToken), entityKind);
            operationSuccessful = true;
            PropertyTypeEntityTypeRelation[] propertyTypeEntityTypeRelationArray = result;
            return propertyTypeEntityTypeRelationArray;
        }
        finally {
            this.logAccessUserBehaviour(this.createLogger(sessionToken, operationSuccessful).listPropertyTypes(entityKind));
        }
    }

    public final PropertyType[] listPropertyTypes(String sessionToken) {
        boolean operationSuccessful = false;
        try {
            this.checkAccess(sessionToken);
            IEntityPropertyManager entityPropertyManager = this.domainModel.getEntityPropertyManager();
            PropertyType[] result = entityPropertyManager.listPropertyTypes(this.getSession(sessionToken));
            operationSuccessful = true;
            PropertyType[] propertyTypeArray = result;
            return propertyTypeArray;
        }
        finally {
            this.logAccessUserBehaviour(this.createLogger(sessionToken, operationSuccessful).listPropertyTypes(null));
        }
    }

    public final SimpleEntityPropertySchema[] listEntityPropertyTypes(String sessionToken, EntityKind entityKind, String entityTypeCode) {
        boolean operationSuccessful = false;
        try {
            this.checkAccess(sessionToken);
            SimpleEntityPropertySchema[] result = this.domainModel.getEntityPropertyManager().listPropertyTypes(entityKind, entityTypeCode);
            operationSuccessful = true;
            SimpleEntityPropertySchema[] simpleEntityPropertySchemaArray = result;
            return simpleEntityPropertySchemaArray;
        }
        finally {
            this.logAccessUserBehaviour(this.createLogger(sessionToken, operationSuccessful).getEntityTypeInfo(entityTypeCode, entityKind));
        }
    }

    public final SampleGeneration getSampleInfo(String sessionToken, String sampleCode) throws UserFailureException {
        boolean operationSuccessful = false;
        try {
            this.checkAccess(sessionToken);
            ISampleManager sampleManager = this.domainModel.getSampleManager();
            SampleGeneration sampleInfo = sampleManager.getSampleInfo(this.getSession(sessionToken), sampleCode);
            operationSuccessful = true;
            SampleGeneration sampleGeneration = sampleInfo;
            return sampleGeneration;
        }
        finally {
            this.logAccessUserBehaviour(this.createLogger(sessionToken, operationSuccessful).getSampleInfo(sampleCode));
        }
    }

    public final String assignEntityPropertyType(String sessionToken, EntityKind entityKind, String entityTypeCode, String propertyName, boolean mandatory, EntityPropertyFiller[] propertyFillers, String defaultValueOrNull) {
        boolean operationSuccessful = false;
        try {
            this.checkAccess(sessionToken);
            IEntityPropertyManager entityPropertyManager = this.domainModel.getEntityPropertyManager();
            String result = entityPropertyManager.assignPropertyType(this.getSession(sessionToken), entityKind, entityTypeCode, propertyName, mandatory, propertyFillers, defaultValueOrNull);
            operationSuccessful = true;
            String string = result;
            return string;
        }
        finally {
            this.logTrackingUserBehaviour(this.createLogger(sessionToken, operationSuccessful).assignEntityPropertyType(entityKind, entityTypeCode, propertyName, mandatory, propertyFillers));
        }
    }

    public final Void unassignEntityPropertyType(String sessionToken, EntityKind entityKind, String entityTypeCode, String propertyTypeCode) throws UserFailureException {
        boolean operationSuccessful = false;
        try {
            this.checkAccess(sessionToken);
            IEntityPropertyManager entityPropertyManager = this.domainModel.getEntityPropertyManager();
            entityPropertyManager.unassignPropertyType(this.getSession(sessionToken), entityKind, propertyTypeCode, entityTypeCode);
            operationSuccessful = true;
            return null;
        }
        finally {
            this.logTrackingUserBehaviour(this.createLogger(sessionToken, operationSuccessful).unassignEntityPropertyType(entityKind, entityTypeCode, propertyTypeCode));
        }
    }

    public final long countPropertyTypedEntities(String sessionToken, EntityKind entityKind, String entityTypeCode, String propertyTypeCode) throws UserFailureException {
        boolean operationSuccessful = false;
        try {
            this.checkAccess(sessionToken);
            Session session = this.getSession(sessionToken);
            Long result = this.domainModel.getPropertyTypeManager().countEntitiesWithProperty(session, entityKind, entityTypeCode, propertyTypeCode);
            operationSuccessful = true;
            long l = result;
            return l;
        }
        finally {
            this.logAccessUserBehaviour(this.createLogger(sessionToken, operationSuccessful).listPropertyTypedEntities(entityKind.name(), entityTypeCode, propertyTypeCode));
        }
    }

    public final String[] invalidateSamples(String sessionToken, String[] sampleCodes, String invalidationReasonOrNull) throws UserFailureException {
        boolean operationSuccessful = false;
        try {
            this.checkAccess(sessionToken);
            String[] result = this.domainModel.getSampleManager().invalidateSamples(this.getSession(sessionToken), sampleCodes, invalidationReasonOrNull);
            operationSuccessful = true;
            String[] stringArray = result;
            return stringArray;
        }
        finally {
            this.logTrackingUserBehaviour(this.createLogger(sessionToken, operationSuccessful).invalidateSamples(sampleCodes, invalidationReasonOrNull));
        }
    }

    public Void invalidateExperiment(String sessionToken, ExperimentIdentifier experimentIdentifier, String invalidationReasonOrNull) throws UserFailureException {
        boolean operationSuccessful = false;
        try {
            this.checkAccess(sessionToken);
            IExperimentManager experimentManager = this.domainModel.getExperimentManager();
            experimentManager.invalidate(this.getSession(sessionToken), experimentIdentifier, invalidationReasonOrNull);
            operationSuccessful = true;
            return null;
        }
        finally {
            this.logTrackingUserBehaviour(this.createLogger(sessionToken, operationSuccessful).invalidateExperiment(experimentIdentifier, invalidationReasonOrNull));
        }
    }

    public SampleComponentsLayout getSampleMergedLayout(String sessionToken, String sampleCode) throws UserFailureException {
        boolean operationSuccessful = false;
        try {
            this.checkAccess(sessionToken);
            SampleComponentsLayout result = this.domainModel.getSampleManager().getSampleMergedLayout(this.getSession(sessionToken), sampleCode, true);
            operationSuccessful = true;
            SampleComponentsLayout sampleComponentsLayout = result;
            return sampleComponentsLayout;
        }
        finally {
            this.logAccessUserBehaviour(this.createLogger(sessionToken, operationSuccessful).getSampleLayout(sampleCode));
        }
    }

    public Void registerVocabulary(String sessionToken, String vocabularyName, String vocabularyDescOrNull, String[] vocabularyTerms, boolean addTerms) {
        boolean operationSuccessful = false;
        try {
            this.checkAccess(sessionToken);
            this.domainModel.getPropertyTypeManager().registerVocabulary(this.getSession(sessionToken), vocabularyName, vocabularyDescOrNull, vocabularyTerms, addTerms);
            operationSuccessful = true;
            return null;
        }
        finally {
            this.logTrackingUserBehaviour(this.createLogger(sessionToken, operationSuccessful).registerVocabulary(vocabularyName, vocabularyDescOrNull, vocabularyTerms, addTerms));
        }
    }

    public SampleType[] listSampleTypes(String sessionToken) throws UserFailureException {
        boolean operationSuccessful = false;
        try {
            this.checkAccess(sessionToken);
            List<SampleTypeDTO> list = this.domainModel.getSampleManager().listSampleTypes(this.getSession(sessionToken));
            SampleType[] result = BeanUtils.createBeanList(SampleType.class, list).toArray(new SampleType[list.size()]);
            operationSuccessful = true;
            SampleType[] sampleTypeArray = result;
            return sampleTypeArray;
        }
        finally {
            this.logAccessUserBehaviour(this.createLogger(sessionToken, operationSuccessful).listSampleTypes());
        }
    }

    private static class AbstractExperimentConverter
    implements BeanUtils.Converter {
        static final BeanUtils.Converter ABSTRACT_EXPERIMENT_INSTANCE = new AbstractExperimentConverter();

        private AbstractExperimentConverter() {
        }

        public final SimpleEntityProperty[] convertToProperties(AbstractExperimentDTO entity) {
            return entity.getSimpleProperties();
        }
    }

    private static final class BaseExperimentConverter
    extends AbstractExperimentConverter {
        static final BeanUtils.Converter BASE_EXPERIMENT_INSTANCE = new BaseExperimentConverter();

        private BaseExperimentConverter() {
        }

        public final boolean convertToInvalidated(BaseExperimentDTO experimentDTO) {
            return experimentDTO.getInvalidationId() != null;
        }
    }
}

