/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.webservice;

import ch.systemsx.cisd.common.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.utilities.FileUtilities;
import ch.systemsx.cisd.lims.base.server.Role;
import ch.systemsx.cisd.lims.server.business.IRolesManager;
import ch.systemsx.cisd.lims.server.business.Session;
import ch.systemsx.cisd.lims.webservice.DefaultRolesManager;
import ch.systemsx.cisd.lims.webservice.IAccessController;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RoleBasedAccessController
implements IAccessController {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, RoleBasedAccessController.class);
    private final AtomicReference<IRolesManager> rolesManagerReference = new AtomicReference();
    private Class<?> interfaceToGuard;
    private String userRolesResource;

    public RoleBasedAccessController(String interfaceToGuard, String userRolesResource) throws ClassNotFoundException {
        this(Class.forName(interfaceToGuard), userRolesResource);
    }

    public RoleBasedAccessController(Class<?> interfaceToGuard, String userRolesResource) {
        this(interfaceToGuard, RoleBasedAccessController.readUserRoleDefinition(userRolesResource));
        this.userRolesResource = userRolesResource;
    }

    public RoleBasedAccessController(Class<?> interfaceToGuard, List<String> userRoleDefinition) {
        this(new DefaultRolesManager(interfaceToGuard, userRoleDefinition));
        this.interfaceToGuard = interfaceToGuard;
    }

    public RoleBasedAccessController(IRolesManager rolesManager) {
        this.setRolesManager(rolesManager);
    }

    private final void setRolesManager(IRolesManager rolesManager) {
        assert (rolesManager != null) : "Given roles manager can not be null.";
        this.rolesManagerReference.set(rolesManager);
    }

    final String getUserRolesResource() {
        return this.userRolesResource;
    }

    private static final List<String> readUserRoleDefinition(String userRolesResource) {
        try {
            List<String> userRoleDefinition = FileUtilities.loadToStringList(RoleBasedAccessController.class, userRolesResource);
            if (userRoleDefinition == null) {
                throw ConfigurationFailureException.fromTemplate("User role resource '%s' not found.", userRolesResource);
            }
            return userRoleDefinition;
        }
        catch (CheckedExceptionTunnel ex) {
            if (!(ex.getCause() instanceof IOException)) {
                throw ex;
            }
            throw ConfigurationFailureException.fromTemplate(ex.getCause(), "Error reading the user roles definitions from file '%s'.", userRolesResource);
        }
    }

    private static final Set<Role> intersect(Set<Role> roleSet1, Set<Role> roleSet2) {
        HashSet<Role> intersection = new HashSet<Role>(roleSet1);
        intersection.retainAll(roleSet2);
        return intersection;
    }

    public final ChangeListener tryCreateChangeListener() {
        if (this.interfaceToGuard == null || this.userRolesResource == null) {
            return null;
        }
        return new ChangeListener(){

            public final void stateChanged(ChangeEvent e) {
                RoleBasedAccessController.this.setRolesManager(new DefaultRolesManager(RoleBasedAccessController.this.interfaceToGuard, RoleBasedAccessController.readUserRoleDefinition(RoleBasedAccessController.this.userRolesResource)));
                if (operationLog.isInfoEnabled()) {
                    operationLog.info(String.format("User roles definition specified in '%s' for interface '%s' has been reloaded.", RoleBasedAccessController.this.userRolesResource, RoleBasedAccessController.this.interfaceToGuard));
                }
            }
        };
    }

    @Override
    public final boolean isAuthorized(Session session, String method) {
        IRolesManager rolesManager = this.rolesManagerReference.get();
        Set<Role> roleIntersection = RoleBasedAccessController.intersect(rolesManager.getMethodRoles(method), rolesManager.getUserRoles(session.getUserName()));
        return !roleIntersection.isEmpty();
    }
}

