/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.db;

import ch.systemsx.cisd.common.db.DBTableRestrictions;
import ch.systemsx.cisd.common.db.SQLCommandTokenizer;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBRestrictionParser {
    private static final String CREATE_DOMAIN_PREFIX = "create domain ";
    private static final Pattern VARCHAR_PATTERN = Pattern.compile("(varchar|character varying)\\(([0-9]+)\\).*");
    private static final String CREATE_TABLE_PREFIX = "create table ";
    private static final Pattern CREATE_TABLE_PATTERN = Pattern.compile("create table ([a-z,0-9,_]+) \\((.+)\\)");
    private static final Pattern NOT_NULL_TABLE_PATTERN = Pattern.compile("\\w+ ((default .+ not null)|(not null)|(not null .+ default.+))");
    private static final String ALTER_TABLE_PREFIX = "alter table ";
    private static final Pattern CHECK_CONSTRAINT_PATTERN = Pattern.compile("alter table ([a-z,0-9,_]+) add constraint [a-z,0-9,_]+ check \\(([a-z,0-9,_]+) in \\((.+)\\)\\)");
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, DBRestrictionParser.class);
    final Map<String, DBTableRestrictions> tableRestrictionMap = new HashMap<String, DBTableRestrictions>();

    public DBRestrictionParser(String ddlScript) {
        List<String> normalizedDDLScript = DBRestrictionParser.normalize(ddlScript);
        Map<String, Integer> domains = DBRestrictionParser.parseDomains(normalizedDDLScript);
        this.parseColumnLength(normalizedDDLScript, domains);
        this.parserCheckedConstraints(normalizedDDLScript);
    }

    static List<String> normalize(String ddlScript) {
        String command;
        ArrayList<String> list = new ArrayList<String>();
        SQLCommandTokenizer normalizer = new SQLCommandTokenizer(ddlScript);
        do {
            if ((command = normalizer.getNextCommand()) == null) continue;
            list.add(command);
        } while (command != null);
        return list;
    }

    static Map<String, Integer> parseDomains(List<String> ddlScript) {
        HashMap<String, Integer> domains = new HashMap<String, Integer>();
        for (String line : ddlScript) {
            if (!line.startsWith(CREATE_DOMAIN_PREFIX)) continue;
            String domainDefinition = line.substring(CREATE_DOMAIN_PREFIX.length());
            int indexOfAS = domainDefinition.indexOf("as");
            if (indexOfAS < 0) {
                operationLog.warn((Object)("line \"" + line + "\" starts like a domain definition, but key word 'AS' is missing."));
                continue;
            }
            String domainName = domainDefinition.substring(0, indexOfAS).trim();
            Matcher varCharMatcher = VARCHAR_PATTERN.matcher(domainDefinition = domainDefinition.substring(indexOfAS + 2).trim());
            if (!varCharMatcher.matches()) continue;
            domains.put(domainName, Integer.parseInt(varCharMatcher.group(2)));
        }
        return domains;
    }

    private void parseColumnLength(List<String> ddlScript, Map<String, Integer> domains) {
        for (String line : ddlScript) {
            String[] columnDefinitions;
            Matcher createTableMatcher = CREATE_TABLE_PATTERN.matcher(line);
            if (!createTableMatcher.matches()) continue;
            String tableName = createTableMatcher.group(1);
            String tableDefinition = createTableMatcher.group(2);
            String[] stringArray = columnDefinitions = StringUtils.split((String)tableDefinition, (char)',');
            int n = columnDefinitions.length;
            int n2 = 0;
            while (n2 < n) {
                String columnDefinition = stringArray[n2];
                this.parseColumnDefinition(columnDefinition, tableName, domains);
                ++n2;
            }
        }
    }

    private void parseColumnDefinition(String columnDefinition, String tableName, Map<String, Integer> domains) throws NumberFormatException {
        String typeDefinition;
        Matcher varCharMatcher;
        if (columnDefinition.startsWith("constraint ")) {
            return;
        }
        int indexOfFirstSpace = columnDefinition.indexOf(32);
        if (indexOfFirstSpace < 0) {
            operationLog.warn((Object)("Invalid column definition \"" + columnDefinition + "\" for table " + tableName));
            return;
        }
        String columnName = columnDefinition.substring(0, indexOfFirstSpace).trim();
        if (columnName.startsWith("\"") && columnName.endsWith("\"")) {
            columnName = columnName.substring(1, columnName.length() - 1);
        }
        if ((varCharMatcher = VARCHAR_PATTERN.matcher(typeDefinition = columnDefinition.substring(indexOfFirstSpace).trim())).matches()) {
            this.getTableRestrictions((String)tableName).columnLengthMap.put(columnName, Integer.parseInt(varCharMatcher.group(2)));
        } else {
            Integer domainLength = domains.get(StringUtils.split((String)typeDefinition, (char)' ')[0]);
            if (domainLength != null) {
                this.getTableRestrictions((String)tableName).columnLengthMap.put(columnName, domainLength);
            }
        }
        if (NOT_NULL_TABLE_PATTERN.matcher(typeDefinition).matches()) {
            this.getTableRestrictions((String)tableName).notNullSet.add(columnName);
        }
    }

    private void parserCheckedConstraints(List<String> ddlScript) {
        for (String line : ddlScript) {
            Matcher checkedConstraintMatcher = CHECK_CONSTRAINT_PATTERN.matcher(line);
            if (!checkedConstraintMatcher.matches()) continue;
            String tableName = checkedConstraintMatcher.group(1);
            String columnName = checkedConstraintMatcher.group(2);
            String alternativesStr = checkedConstraintMatcher.group(3);
            String[] alternatives = StringUtils.split((String)alternativesStr, (char)',');
            HashSet<String> alternativeSet = new HashSet<String>();
            String[] stringArray = alternatives;
            int n = alternatives.length;
            int n2 = 0;
            while (n2 < n) {
                String alternative = stringArray[n2];
                if (alternative.charAt(0) != '\'' || alternative.charAt(alternative.length() - 1) != '\'') {
                    operationLog.warn((Object)("Invalid alternatives definition \"" + alternative + "\" for column " + columnName + " of table " + tableName));
                } else {
                    alternativeSet.add(alternative.substring(1, alternative.length() - 1));
                }
                ++n2;
            }
            this.getTableRestrictions((String)tableName).checkedConstraintsMap.put(columnName, alternativeSet);
        }
    }

    DBTableRestrictions getTableRestrictions(String tableName) {
        DBTableRestrictions table = this.tableRestrictionMap.get(tableName);
        if (table == null) {
            table = new DBTableRestrictions();
            this.tableRestrictionMap.put(tableName, table);
        }
        return table;
    }

    public Map<String, DBTableRestrictions> getDBRestrictions() {
        return Collections.unmodifiableMap(this.tableRestrictionMap);
    }
}

