/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.utilities;

import ch.systemsx.cisd.common.utilities.OSUtilities;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.io.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BuildAndEnvironmentInfo {
    private static final String UNKNOWN = "UNKNOWN";
    public static final BuildAndEnvironmentInfo INSTANCE = new BuildAndEnvironmentInfo();
    private final String version;
    private final String revision;
    private final boolean cleanSources;

    private BuildAndEnvironmentInfo() {
        boolean extractedCleanFlag;
        String extractedRevision;
        String extractedVersion;
        block7: {
            extractedVersion = UNKNOWN;
            extractedRevision = UNKNOWN;
            extractedCleanFlag = false;
            InputStream stream = BuildAndEnvironmentInfo.class.getResourceAsStream("/BUILD.INFO");
            if (stream != null) {
                BufferedReader reader = null;
                try {
                    try {
                        reader = new BufferedReader(new InputStreamReader(stream));
                        String line = reader.readLine();
                        if (line != null) {
                            StringTokenizer tokenizer = new StringTokenizer(line, ":");
                            extractedVersion = tokenizer.nextToken();
                            extractedRevision = tokenizer.nextToken();
                            extractedCleanFlag = "clean".equals(tokenizer.nextToken());
                        }
                    }
                    catch (IOException iOException) {
                        IOUtils.closeQuietly(reader);
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(reader);
                    throw throwable;
                }
                IOUtils.closeQuietly((Reader)reader);
            }
        }
        this.version = extractedVersion;
        this.revision = extractedRevision;
        this.cleanSources = extractedCleanFlag;
    }

    private static final String getProperty(String property) {
        return System.getProperty(property, UNKNOWN);
    }

    private static final boolean isUnknown(String property) {
        return property.equals(UNKNOWN);
    }

    public final String getCPUArchitecture() {
        return BuildAndEnvironmentInfo.getProperty("os.arch");
    }

    public final String getOS() {
        String osName = BuildAndEnvironmentInfo.getProperty("os.name");
        String osVersion = BuildAndEnvironmentInfo.getProperty("os.version");
        if (BuildAndEnvironmentInfo.isUnknown(osName) || BuildAndEnvironmentInfo.isUnknown(osVersion)) {
            return osName;
        }
        return String.valueOf(osName) + " (v" + osVersion + ")";
    }

    public final String getJavaVM() {
        String vmName = BuildAndEnvironmentInfo.getProperty("java.vm.name");
        String vmVersion = BuildAndEnvironmentInfo.getProperty("java.vm.version");
        if (BuildAndEnvironmentInfo.isUnknown(vmName) || BuildAndEnvironmentInfo.isUnknown(vmVersion)) {
            return vmName;
        }
        return String.valueOf(vmName) + " (v" + vmVersion + ")";
    }

    public final String getVersion() {
        return this.version;
    }

    public final boolean isCleanSources() {
        return this.cleanSources;
    }

    public final String getRevision() {
        return this.revision;
    }

    public final String getFullVersion() {
        StringBuilder builder = new StringBuilder();
        String rev = this.getRevision();
        boolean isDirty = !this.isCleanSources();
        builder.append(this.getVersion());
        if (!BuildAndEnvironmentInfo.isUnknown(rev)) {
            builder.append(" (r").append(rev);
            if (isDirty) {
                builder.append("*");
            }
            builder.append(")");
        } else if (isDirty) {
            builder.append("*");
        }
        return builder.toString();
    }

    public final List<String> getEnvironmentInfo() {
        ArrayList<String> environmentInfo = new ArrayList<String>();
        environmentInfo.add("Version: " + this.getFullVersion());
        environmentInfo.add("Java VM: " + this.getJavaVM());
        environmentInfo.add("CPU Architecture: " + this.getCPUArchitecture());
        environmentInfo.add("OS: " + this.getOS());
        return environmentInfo;
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        List<String> environmentInfo = this.getEnvironmentInfo();
        int n = environmentInfo.size();
        int i = 0;
        while (i < n) {
            builder.append(environmentInfo.get(i));
            if (i < n - 1) {
                builder.append(OSUtilities.LINE_SEPARATOR);
            }
            ++i;
        }
        return builder.toString();
    }

    public static void main(String[] args) {
        System.out.println(INSTANCE);
    }
}

