/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.utilities;

import java.util.Calendar;
import java.util.Date;

public final class DateTimeUtils {
    public static final String getTimeZone(Date date) {
        assert (date != null) : "Unspecified date.";
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        StringBuffer zoneString = new StringBuffer();
        int value = calendar.get(15) + calendar.get(16);
        if (value < 0) {
            zoneString.append('-');
            value = -value;
        } else {
            zoneString.append('+');
        }
        int num = value / 3600000;
        zoneString.append(DateTimeUtils.prependZeroIfNeeded(num));
        zoneString.append(":");
        num = value % 3600000 / 60000;
        zoneString.append(DateTimeUtils.prependZeroIfNeeded(num));
        return "GMT" + zoneString.toString();
    }

    private static final String prependZeroIfNeeded(int num) {
        return num < 10 ? "0" + num : "" + num;
    }
}

