/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.utilities;

import ch.systemsx.cisd.common.TimingParameters;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.utilities.FastHardLinkMaker;
import ch.systemsx.cisd.common.utilities.HardLinkMaker;
import ch.systemsx.cisd.common.utilities.IDirectoryImmutableCopier;
import ch.systemsx.cisd.common.utilities.IFileImmutableCopier;
import ch.systemsx.cisd.common.utilities.IImmutableCopier;
import ch.systemsx.cisd.common.utilities.OSUtilities;
import ch.systemsx.cisd.common.utilities.RecursiveHardLinkMaker;
import ch.systemsx.cisd.common.utilities.RsyncBasedRecursiveHardLinkMaker;
import java.io.File;
import org.apache.log4j.Logger;

public class FastRecursiveHardLinkMaker
implements IImmutableCopier {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, FastRecursiveHardLinkMaker.class);
    private static final String RSYNC_EXEC = "rsync";
    private static final int DEFAULT_MAX_ERRORS_TO_IGNORE = 3;
    private final IImmutableCopier fallbackCopierOrNull;
    private final IFileImmutableCopier fastFileCopierOrNull;
    private final IDirectoryImmutableCopier fastDirectoryCopierOrNull;

    public static final IImmutableCopier tryCreate() {
        return FastRecursiveHardLinkMaker.tryCreate(TimingParameters.getDefaultParameters());
    }

    public static final IImmutableCopier tryCreate(TimingParameters timingParameters) {
        File rsyncExecOrNull = OSUtilities.findExecutable(RSYNC_EXEC);
        if (rsyncExecOrNull == null) {
            return null;
        }
        return FastRecursiveHardLinkMaker.create(rsyncExecOrNull, timingParameters);
    }

    public static final IImmutableCopier create(File rsyncExecutable, TimingParameters parameters) {
        return FastRecursiveHardLinkMaker.create(rsyncExecutable, parameters, false);
    }

    public static final IImmutableCopier create(File rsyncExecutable) {
        return FastRecursiveHardLinkMaker.create(rsyncExecutable, TimingParameters.getDefaultParameters(), false);
    }

    public static final IImmutableCopier create(File rsyncExecutable, TimingParameters parameters, boolean neverUseNative) {
        return new FastRecursiveHardLinkMaker(rsyncExecutable, parameters, neverUseNative);
    }

    private FastRecursiveHardLinkMaker(File rsyncExcutable, TimingParameters timingParameters, boolean neverUseNative) throws ConfigurationFailureException {
        this.fastFileCopierOrNull = neverUseNative ? null : FastHardLinkMaker.tryCreate(timingParameters);
        this.fastDirectoryCopierOrNull = new RsyncBasedRecursiveHardLinkMaker(rsyncExcutable, timingParameters, 3);
        this.fallbackCopierOrNull = this.fastFileCopierOrNull == null ? RecursiveHardLinkMaker.tryCreate(HardLinkMaker.tryCreate(timingParameters)) : RecursiveHardLinkMaker.tryCreate(this.fastFileCopierOrNull);
        if (this.fastFileCopierOrNull == null && this.fallbackCopierOrNull == null || this.fastDirectoryCopierOrNull == null && this.fallbackCopierOrNull == null) {
            throw new ConfigurationFailureException("Not operational");
        }
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)timingParameters.toString());
            if (this.fastFileCopierOrNull != null) {
                operationLog.info((Object)"Using native library to create hard link copies of files.");
            } else {
                operationLog.info((Object)"Using 'ln' to create hard link copies of files.");
            }
            if (this.fastDirectoryCopierOrNull != null) {
                operationLog.info((Object)"Using 'rsync' to traverse directories when making recursive hard link copies.");
            } else {
                operationLog.info((Object)"Using Java to traverse directories when making recursive hard link copies");
            }
        }
    }

    public boolean copyImmutably(File source, File destinationDirectory, String nameOrNull) {
        if (source.isDirectory()) {
            if (this.fastDirectoryCopierOrNull != null) {
                return this.fastDirectoryCopierOrNull.copyDirectoryImmutably(source, destinationDirectory, nameOrNull);
            }
            return this.fallbackCopierOrNull.copyImmutably(source, destinationDirectory, nameOrNull);
        }
        if (this.fastFileCopierOrNull != null) {
            return this.fastFileCopierOrNull.copyFileImmutably(source, destinationDirectory, nameOrNull);
        }
        return this.fallbackCopierOrNull.copyImmutably(source, destinationDirectory, nameOrNull);
    }
}

