/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.base.util;

import ch.systemsx.cisd.lims.base.PlateDimension;
import ch.systemsx.cisd.lims.base.properties.SimpleEntityProperty;

public class PlateDimensionParser {
    public static final String PLATE_GEOMETRY_PROPERTY_NAME = "PLATE_GEOMETRY";

    public static PlateDimension getPlateDimension(SimpleEntityProperty[] properties) {
        PlateDimension plateDimension = PlateDimensionParser.tryToGetPlateDimension(properties);
        if (plateDimension == null) {
            throw new IllegalArgumentException("Cannot find property PLATE_GEOMETRY");
        }
        return plateDimension;
    }

    public static PlateDimension tryToGetPlateDimension(SimpleEntityProperty[] properties) {
        String plateGeometryString = PlateDimensionParser.tryFindProperty(properties, PLATE_GEOMETRY_PROPERTY_NAME);
        if (plateGeometryString == null) {
            return null;
        }
        PlateDimension dimension = PlateDimensionParser.tryParsePlateDimension(plateGeometryString);
        if (dimension == null) {
            throw new IllegalArgumentException("Cannot parse plate geometry " + plateGeometryString);
        }
        return dimension;
    }

    private static PlateDimension tryParsePlateDimension(String plateGeometryString) {
        String[] tokens = plateGeometryString.split("_");
        String sizeToken = tokens[tokens.length - 1];
        String[] dims = sizeToken.split("X");
        if (dims.length != 2) {
            return null;
        }
        Integer rows = PlateDimensionParser.tryParseInteger(dims[0]);
        Integer cols = PlateDimensionParser.tryParseInteger(dims[1]);
        if (rows == null || cols == null) {
            return null;
        }
        return new PlateDimension(rows, cols);
    }

    private static Integer tryParseInteger(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private static String tryFindProperty(SimpleEntityProperty[] properties, String propertyName) {
        SimpleEntityProperty[] simpleEntityPropertyArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            SimpleEntityProperty property = simpleEntityPropertyArray[n2];
            if (property.getCode().equals(propertyName)) {
                return property.getUntypedValue();
            }
            ++n2;
        }
        return null;
    }
}

