/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.datasetdownload;

import ch.systemsx.cisd.lims.base.ExternalData;
import ch.systemsx.cisd.openbis.datasetdownload.IDirectoryRenderer;
import ch.systemsx.cisd.openbis.datasetdownload.IErrorRenderer;
import ch.systemsx.cisd.openbis.datasetdownload.IRendererFactory;
import ch.systemsx.cisd.openbis.datasetdownload.RenderingContext;
import java.io.PrintWriter;
import org.apache.commons.io.FileUtils;

public class PlainTextRendererFactory
implements IRendererFactory {
    public IDirectoryRenderer createDirectoryRenderer(RenderingContext context) {
        return new PlainTextDirectoryRenderer();
    }

    public IErrorRenderer createErrorRenderer() {
        return new IErrorRenderer(){
            private PrintWriter writer;

            public void printErrorMessage(String errorMessage) {
                this.writer.println("Error:");
                this.writer.println(errorMessage);
            }

            public void setWriter(PrintWriter writer) {
                this.writer = writer;
            }
        };
    }

    public String getContentType() {
        return "text";
    }

    private static class PlainTextDirectoryRenderer
    implements IDirectoryRenderer {
        private PrintWriter writer;

        private PlainTextDirectoryRenderer() {
        }

        public String getContentType() {
            return "text";
        }

        public void printDirectory(String name, String relativePath) {
            this.writer.print(String.valueOf(name) + "\n");
        }

        public void printFile(String name, String relativePath, long size) {
            this.writer.format("%s\t%s\n", name, FileUtils.byteCountToDisplaySize((long)size));
        }

        public void printFooter() {
        }

        public void printHeader(ExternalData dataSet) {
            this.writer.println("Directory content:");
        }

        public void printLinkToParentDirectory(String relativePath) {
        }

        public void setWriter(PrintWriter writer) {
            this.writer = writer;
        }
    }
}

