/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.args4j;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ResourceBundle;
import org.kohsuke.args4j.CmdLineOptions;
import org.kohsuke.args4j.ExampleMode;
import org.kohsuke.args4j.spi.OptionHandler;

class CmdLineOptionPrinter {
    private final CmdLineOptions options;
    private int usageWidth = 80;

    CmdLineOptionPrinter(CmdLineOptions options) {
        this.options = options;
    }

    void setTerminalWidth(int usageWidth) {
        this.usageWidth = usageWidth;
    }

    void printHelp(String programCall, String genericOptions, String genericArgs, ExampleMode mode) {
        System.err.println(String.valueOf(programCall) + " " + genericOptions + " " + genericArgs);
        this.printUsage(System.err);
        System.err.println();
        if (!ExampleMode.NONE.equals((Object)mode)) {
            System.err.println("  Example: " + programCall + this.getExampleString(mode) + " " + genericArgs);
        }
    }

    String getExampleString(ExampleMode mode) {
        return this.getExampleString(mode, null);
    }

    String getExampleString(ExampleMode mode, ResourceBundle rb) {
        if (ExampleMode.NONE.equals((Object)mode)) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        for (OptionHandler handler : this.options.getHandlers()) {
            if (!handler.printForExample(mode)) continue;
            buf.append(' ');
            if (handler.getName().length() > 0) {
                buf.append(handler.getName());
            } else {
                buf.append(handler.getLongName());
            }
            String metaVar = handler.getMetaVariable(rb);
            if (metaVar == null) continue;
            buf.append(' ').append(metaVar);
        }
        return buf.toString();
    }

    public void printUsage(OutputStream out) {
        this.printUsage(new OutputStreamWriter(out), null);
    }

    public void printUsage(Writer out, ResourceBundle rb) {
        PrintWriter w = new PrintWriter(out);
        int maxOptionLength = this.options.getMaxOptionPrintLength(rb);
        for (OptionHandler handler : this.options.getHandlers()) {
            this.print(w, rb, handler, maxOptionLength);
        }
        w.flush();
    }

    private void print(PrintWriter w, ResourceBundle rb, OptionHandler handler, int maxOptionLength) {
        String usage = handler.getUsage();
        if (handler.isRequired()) {
            usage = String.valueOf(usage) + " (required)";
        }
        if (usage.length() == 0) {
            return;
        }
        w.print(' ');
        String optionName = handler.getName();
        String longOptionName = handler.getLongName();
        int headLen = 0;
        if (optionName.length() > 0) {
            if (longOptionName.length() > 0) {
                headLen = optionName.length() + longOptionName.length() + 3;
                w.print('[');
                w.print(optionName);
                w.print(',');
                w.print(longOptionName);
                w.print(']');
            } else {
                headLen = optionName.length();
                w.print(optionName);
            }
        } else {
            headLen = longOptionName.length();
            w.print(longOptionName);
        }
        String metaVar = handler.getMetaVariable(rb);
        if (metaVar != null) {
            w.print(' ');
            w.print(metaVar);
            headLen += metaVar.length() + 1;
        }
        while (headLen < maxOptionLength) {
            w.print(' ');
            ++headLen;
        }
        w.print(" : ");
        if (rb != null) {
            usage = rb.getString(usage);
        }
        int descriptionWidth = this.usageWidth - maxOptionLength - 4;
        while (usage != null && usage.length() > 0) {
            String[] lines = CmdLineOptionPrinter.split(usage, descriptionWidth);
            w.println(lines[0]);
            usage = lines[1];
            if (usage.length() <= 0) continue;
            CmdLineOptionPrinter.indent(w, maxOptionLength + 4);
        }
    }

    private static String[] split(String s, int maxLength) {
        int length = s.indexOf(10);
        int offset = length + 1;
        if (length >= 0 && length <= maxLength) {
            return new String[]{s.substring(0, length), s.substring(offset)};
        }
        if (s.length() <= maxLength) {
            return new String[]{s, ""};
        }
        length = maxLength;
        offset = maxLength;
        while (s.charAt(length) != ' ' && length > 0) {
            --length;
        }
        if (s.charAt(length) == ' ') {
            offset = length + 1;
        } else {
            length = maxLength;
            offset = maxLength;
        }
        return new String[]{s.substring(0, length), s.substring(offset)};
    }

    private static void indent(PrintWriter w, int count) {
        int i = count;
        while (i > 0) {
            w.print(' ');
            --i;
        }
    }
}

