/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.bds.hcs;

import ch.systemsx.cisd.bds.IStorable;
import ch.systemsx.cisd.bds.Utilities;
import ch.systemsx.cisd.bds.exception.DataStructureException;
import ch.systemsx.cisd.bds.storage.IDirectory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Channel
implements IStorable,
Comparable<Channel> {
    static final String CHANNEL = "channel";
    static final String WAVELENGTH = "wavelength";
    private final int counter;
    private final int wavelength;

    public Channel(int counter, int wavelength) {
        assert (counter > 0) : "Given counter must be > 0.";
        this.counter = counter;
        this.wavelength = wavelength;
    }

    public final int getCounter() {
        return this.counter;
    }

    public final int getWavelength() {
        return this.wavelength;
    }

    static final Channel loadFrom(IDirectory directory) {
        String name = directory.getName();
        assert (name.startsWith(CHANNEL));
        return new Channel(Channel.parseCounter(name), Utilities.getNumber(directory, WAVELENGTH));
    }

    private static int parseCounter(String name) {
        try {
            return Integer.parseInt(name.substring(CHANNEL.length()));
        }
        catch (NumberFormatException ex) {
            throw new DataStructureException(String.format("Could not parse the channel number in '%s'", name), ex);
        }
    }

    @Override
    public final void saveTo(IDirectory directory) {
        IDirectory channelDirectory = directory.makeDirectory(CHANNEL + this.counter);
        channelDirectory.addKeyValuePair(WAVELENGTH, String.valueOf(this.getWavelength()));
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Channel)) {
            return false;
        }
        Channel channel = (Channel)obj;
        return channel.counter == this.counter;
    }

    public final int hashCode() {
        return 629 + this.counter;
    }

    public final String toString() {
        return CHANNEL + this.counter + "[" + this.wavelength + "=" + this.getWavelength() + "]";
    }

    @Override
    public final int compareTo(Channel o) {
        assert (o != null) : "Unspecified Channel.";
        return this.counter - o.counter;
    }
}

