/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.bds.hcs;

import ch.systemsx.cisd.bds.FormatParameter;
import ch.systemsx.cisd.bds.IFormatParameterFactory;
import ch.systemsx.cisd.bds.Utilities;
import ch.systemsx.cisd.bds.hcs.Geometry;
import ch.systemsx.cisd.bds.hcs.PlateGeometry;
import ch.systemsx.cisd.bds.hcs.WellGeometry;
import ch.systemsx.cisd.bds.storage.IDirectory;
import ch.systemsx.cisd.bds.storage.INode;

public final class FormatParameterFactory
implements IFormatParameterFactory {
    private static IFormatParameterFactory instance;

    private FormatParameterFactory() {
    }

    public static final synchronized IFormatParameterFactory getInstance() {
        if (instance == null) {
            instance = new FormatParameterFactory();
        }
        return instance;
    }

    public final FormatParameter createFormatParameter(INode node) {
        assert (node != null) : "Given node can not be null.";
        String nodeName = node.getName();
        if (node instanceof IDirectory) {
            IDirectory directory = (IDirectory)node;
            if (nodeName.equals("plate_geometry")) {
                return new FormatParameter(nodeName, PlateGeometry.loadFrom(directory));
            }
            if (nodeName.equals("well_geometry")) {
                return new FormatParameter(nodeName, WellGeometry.loadFrom(directory));
            }
        }
        FormatParameter formatParameter = IFormatParameterFactory.DEFAULT_FORMAT_PARAMETER_FACTORY.createFormatParameter(node);
        String value = (String)formatParameter.getValue();
        if (nodeName.equals("number_of_channels")) {
            return new FormatParameter("number_of_channels", Integer.parseInt(value));
        }
        if (nodeName.equals("contains_original_data")) {
            return new FormatParameter("contains_original_data", (Object)Utilities.Boolean.fromString(value));
        }
        return formatParameter;
    }

    public final FormatParameter createFormatParameter(String name, String value) {
        if (name.equals("plate_geometry")) {
            Geometry geometry = Geometry.createFromString(value);
            if (geometry != null) {
                return new FormatParameter(name, new PlateGeometry(geometry));
            }
        } else if (name.equals("well_geometry")) {
            Geometry geometry = Geometry.createFromString(value);
            if (geometry != null) {
                return new FormatParameter(name, new WellGeometry(geometry));
            }
        } else {
            if (name.equals("number_of_channels")) {
                return new FormatParameter(name, Integer.parseInt(value));
            }
            if (name.equals("contains_original_data")) {
                return new FormatParameter(name, (Object)Utilities.Boolean.fromString(value));
            }
        }
        return IFormatParameterFactory.DEFAULT_FORMAT_PARAMETER_FACTORY.createFormatParameter(name, value);
    }
}

