/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.bds.storage.filesystem;

import ch.systemsx.cisd.bds.storage.IDirectory;
import ch.systemsx.cisd.bds.storage.IFile;
import ch.systemsx.cisd.bds.storage.IFileBasedFile;
import ch.systemsx.cisd.bds.storage.filesystem.AbstractNode;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.WrappedIOException;
import ch.systemsx.cisd.common.filesystem.FileOperations;
import java.io.InputStream;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class File
extends AbstractNode
implements IFileBasedFile {
    File(java.io.File file) {
        super(file);
        assert (FileOperations.getMonitoredInstanceForCurrentThread().isFile(file)) : "Not a file " + file.getAbsolutePath();
    }

    @Override
    public IDirectory tryAsDirectory() {
        return null;
    }

    @Override
    public IFile tryAsFile() {
        return this;
    }

    @Override
    public final byte[] getBinaryContent() {
        try {
            return FileOperations.getMonitoredInstanceForCurrentThread().getContentAsByteArray(this.nodeFile);
        }
        catch (WrappedIOException ex) {
            throw new EnvironmentFailureException("Can not load data from file " + this.nodeFile.getAbsolutePath(), ex.getCause());
        }
    }

    @Override
    public final InputStream getInputStream() {
        try {
            return FileOperations.getMonitoredInstanceForCurrentThread().getInputStream(this.nodeFile);
        }
        catch (WrappedIOException ex) {
            throw new EnvironmentFailureException("Can not open input stream for file " + this.nodeFile.getAbsolutePath(), ex.getCause());
        }
    }

    @Override
    public final String getStringContent() {
        return FileOperations.getMonitoredInstanceForCurrentThread().getContentAsString(this.nodeFile);
    }

    @Override
    public final List<String> getStringContentList() {
        return FileOperations.getMonitoredInstanceForCurrentThread().getContentAsStringList(this.nodeFile);
    }

    @Override
    public final void extractTo(java.io.File directory) throws EnvironmentFailureException {
        assert (directory != null && directory.isDirectory());
        try {
            FileOperations.getMonitoredInstanceForCurrentThread().copyFileToDirectory(this.nodeFile, directory);
        }
        catch (WrappedIOException ex) {
            throw EnvironmentFailureException.fromTemplate(ex.getCause(), "Can not copy file '%s' to directory '%s'.", this.nodeFile.getAbsolutePath(), directory.getAbsolutePath());
        }
    }
}

