/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.concurrent;

import ch.systemsx.cisd.common.concurrent.ThreadGuard;
import ch.systemsx.cisd.common.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.HardStopException;
import ch.systemsx.cisd.common.exceptions.StopException;
import ch.systemsx.cisd.common.utilities.ITerminable;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TerminableCallable<V>
implements Callable<V>,
ITerminable {
    public static final long NO_WAIT_MILLIS = 0L;
    public static final long WAIT_FOREVER_MILLIS = Long.MAX_VALUE;
    public static final long DEFAULT_WAIT_INTERRUPT_MILLIS = 100L;
    private final ThreadGuard threadGuard = new ThreadGuard();
    private final ICallable<V> delegate;
    private final ICleaner cleanerOrNull;
    private final long waitInterruptMillis;
    private final long timeoutTerminateMillis;

    public static <V> TerminableCallable<V> create(ICallable<V> delegate) {
        return TerminableCallable.create(delegate, null, 100L, Long.MAX_VALUE);
    }

    public static <V> TerminableCallable<V> create(ICallableCleaner<V> delegateWithCleaner) {
        return TerminableCallable.create(delegateWithCleaner, delegateWithCleaner, 100L, Long.MAX_VALUE);
    }

    public static <V> TerminableCallable<V> create(ICallable<V> delegate, ICleaner cleaner) {
        return TerminableCallable.create(delegate, cleaner, 100L, Long.MAX_VALUE);
    }

    public static <V> TerminableCallable<V> create(ICallable<V> delegate, ICleaner cleanerOrNull, long waitInterruptMillis, long timeoutTerminateMillis) {
        return new TerminableCallable<V>(delegate, cleanerOrNull, waitInterruptMillis, timeoutTerminateMillis);
    }

    public static <V> TerminableCallable<V> createStoppable(final Callable<V> delegate) {
        return new TerminableCallable<V>(new ICallable<V>(){

            @Override
            public V call(IStoppableExecutor<V> stoppableExecutor) throws Exception {
                return stoppableExecutor.execute(delegate);
            }
        }, null, 0L, Long.MAX_VALUE);
    }

    private TerminableCallable(ICallable<V> delegate, ICleaner cleanerOrNull, long waitInterruptMillis, long timeoutTerminateMillis) {
        assert (delegate != null);
        this.delegate = delegate;
        this.cleanerOrNull = cleanerOrNull;
        this.waitInterruptMillis = waitInterruptMillis;
        this.timeoutTerminateMillis = timeoutTerminateMillis;
    }

    private void cleanUp(Throwable throwableOrNull) {
        if (this.cleanerOrNull != null) {
            FinishCause cause = throwableOrNull == null ? FinishCause.COMPLETED : (throwableOrNull instanceof HardStopException ? FinishCause.STOPPED : (throwableOrNull instanceof StopException || throwableOrNull instanceof InterruptedException ? FinishCause.INTERRUPTED : FinishCause.EXCEPTION));
            this.cleanerOrNull.cleanUp(cause);
        }
    }

    private InterruptedException getOrCreateInterruptedException(StopException stopEx) {
        InterruptedException causeOrNull = (InterruptedException)stopEx.getCause();
        return causeOrNull != null ? causeOrNull : new InterruptedException();
    }

    @Override
    public V call() throws InterruptedException, CanceledException {
        if (!this.threadGuard.startGuard()) {
            throw new CanceledException();
        }
        Throwable throwableOrNull = null;
        try {
            V result;
            try {
                result = this.delegate.call(new IStoppableExecutor<V>(){

                    @Override
                    public V execute(Callable<V> callable) throws Exception {
                        TerminableCallable.this.threadGuard.allowStopping();
                        try {
                            Object v = callable.call();
                            return v;
                        }
                        finally {
                            TerminableCallable.this.threadGuard.preventStopping();
                        }
                    }

                    @Override
                    public void execute(Runnable runnable) throws Exception {
                        TerminableCallable.this.threadGuard.allowStopping();
                        try {
                            runnable.run();
                        }
                        finally {
                            TerminableCallable.this.threadGuard.preventStopping();
                        }
                    }
                });
            }
            catch (Throwable th) {
                throwableOrNull = th;
                this.threadGuard.shutdownGuard();
                throw CheckedExceptionTunnel.wrapIfNecessary(th);
            }
            this.threadGuard.shutdownGuard();
            V v = result;
            return v;
        }
        catch (StopException ex) {
            throw this.getOrCreateInterruptedException(ex);
        }
        finally {
            this.cleanUp(throwableOrNull);
            this.threadGuard.markFinished();
        }
    }

    public Runnable asRunnable() {
        return new Runnable(){

            public void run() {
                try {
                    TerminableCallable.this.call();
                }
                catch (InterruptedException ex) {
                    throw CheckedExceptionTunnel.wrapIfNecessary(ex);
                }
            }
        };
    }

    public boolean isRunning() {
        return this.threadGuard.isRunning();
    }

    public boolean isCancelled() {
        return this.threadGuard.isCancelled();
    }

    public boolean hasStarted() {
        return this.threadGuard.hasStarted();
    }

    public boolean hasFinished() {
        return this.waitForFinished(0L);
    }

    public boolean waitForFinished(long timeoutMillis) throws StopException {
        try {
            return this.threadGuard.waitForFinished(timeoutMillis);
        }
        catch (InterruptedException ex) {
            throw new StopException(ex);
        }
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.threadGuard.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean terminate() throws StopException {
        return this.terminate(this.timeoutTerminateMillis);
    }

    public boolean terminate(long timeoutMillis) throws StopException {
        try {
            return this.threadGuard.terminateAndWait(this.waitInterruptMillis, timeoutMillis);
        }
        catch (InterruptedException ex) {
            throw new StopException(ex);
        }
    }

    public static class CanceledException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FinishCause {
        COMPLETED,
        INTERRUPTED,
        STOPPED,
        EXCEPTION;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ICallable<V> {
        public V call(IStoppableExecutor<V> var1) throws Exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ICallableCleaner<V>
    extends ICallable<V>,
    ICleaner {
    }

    public static interface ICleaner {
        public void cleanUp(FinishCause var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IStoppableExecutor<V> {
        public void execute(Runnable var1) throws Exception;

        public V execute(Callable<V> var1) throws Exception;
    }
}

