/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.filesystem;

import ch.systemsx.cisd.common.TimingParameters;
import ch.systemsx.cisd.common.concurrent.IActivityObserver;
import ch.systemsx.cisd.common.concurrent.MonitoringProxy;
import ch.systemsx.cisd.common.concurrent.RecordingActivityObserverSensor;
import ch.systemsx.cisd.common.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.WrappedIOException;
import ch.systemsx.cisd.common.filesystem.IFileOperations;
import ch.systemsx.cisd.common.filesystem.IInputStream;
import ch.systemsx.cisd.common.filesystem.IInputStreamAdapter;
import ch.systemsx.cisd.common.filesystem.InputStreamAdapter;
import ch.systemsx.cisd.common.logging.Log4jSimpleLogger;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.utilities.FileUtilities;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.FileCopyUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileOperations
implements IFileOperations {
    static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, IFileOperations.class);
    private static final IFileOperations instance = new FileOperations(null, null);
    private static final ThreadLocal<IFileOperations> monitoredInstanceForThread = new ThreadLocal();
    private final TimingParameters timingParametersOrNull;
    private final IActivityObserver observerOrNull;

    public static IFileOperations getInstance() {
        return instance;
    }

    public static IFileOperations getMonitoredInstanceForCurrentThread() {
        IFileOperations monitoredInstance = monitoredInstanceForThread.get();
        if (monitoredInstance == null) {
            monitoredInstance = FileOperations.internalCreateMonitored(TimingParameters.getDefaultParameters(), new RecordingActivityObserverSensor());
            monitoredInstanceForThread.set(monitoredInstance);
        }
        return monitoredInstance;
    }

    public static IFileOperations createMonitoredInstance(RecordingActivityObserverSensor observerSensor) {
        return FileOperations.internalCreateMonitored(TimingParameters.getDefaultParameters(), observerSensor);
    }

    public static IFileOperations createMonitoredInstance(TimingParameters parameters) {
        if (parameters == TimingParameters.getDefaultParameters()) {
            return FileOperations.getMonitoredInstanceForCurrentThread();
        }
        return FileOperations.internalCreateMonitored(parameters, new RecordingActivityObserverSensor());
    }

    private static IFileOperations internalCreateMonitored(TimingParameters parameters, RecordingActivityObserverSensor observerSensor) {
        return MonitoringProxy.create(IFileOperations.class, new FileOperations(parameters, observerSensor)).timing(parameters).sensor(observerSensor).errorLog(new Log4jSimpleLogger(operationLog)).name("remote file operations").get();
    }

    FileOperations(TimingParameters timingParametersOrNull, IActivityObserver observerOrNull) {
        this.timingParametersOrNull = timingParametersOrNull;
        this.observerOrNull = observerOrNull;
    }

    @Override
    public boolean exists(File file) {
        return file.exists();
    }

    @Override
    public boolean delete(File file) {
        return file.delete();
    }

    @Override
    public boolean rename(File source, File destination) {
        return source.renameTo(destination);
    }

    @Override
    public boolean canRead(File file) {
        return file.canRead();
    }

    @Override
    public boolean canWrite(File file) {
        return file.canWrite();
    }

    @Override
    public boolean createNewFile(File file) throws WrappedIOException {
        try {
            return file.createNewFile();
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    @Override
    public File createTempFile(String prefix, String suffix, File directory) throws WrappedIOException {
        try {
            return File.createTempFile(prefix, suffix, directory);
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    @Override
    public File createTempFile(String prefix, String suffix) throws WrappedIOException {
        try {
            return File.createTempFile(prefix, suffix);
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    @Override
    public File getCanonicalFile(File file) throws WrappedIOException {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    @Override
    public String getCanonicalPath(File file) throws WrappedIOException {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    @Override
    public boolean isDirectory(File file) {
        return file.isDirectory();
    }

    @Override
    public boolean isFile(File file) {
        return file.isFile();
    }

    @Override
    public boolean isHidden(File file) {
        return file.isHidden();
    }

    @Override
    public long lastModified(File file) {
        return file.lastModified();
    }

    @Override
    public long length(File file) {
        return file.length();
    }

    @Override
    public String[] list(File file) {
        return file.list();
    }

    @Override
    public String[] list(File file, FilenameFilter filter) {
        return file.list(filter);
    }

    @Override
    public File[] listFiles(File file) {
        return file.listFiles();
    }

    @Override
    public File[] listFiles(File file, FilenameFilter filter) {
        return file.listFiles(filter);
    }

    @Override
    public File[] listFiles(File file, FileFilter filter) {
        return file.listFiles(filter);
    }

    @Override
    public boolean mkdir(File file) {
        return file.mkdir();
    }

    @Override
    public boolean mkdirs(File file) {
        return file.mkdirs();
    }

    @Override
    public boolean setLastModified(File file, long time) {
        return file.setLastModified(time);
    }

    @Override
    public boolean setReadOnly(File file) {
        return file.setReadOnly();
    }

    @Override
    public List<File> listDirectories(File directory, boolean recursive) {
        return FileUtilities.listDirectories(directory, recursive, this.observerOrNull);
    }

    @Override
    public List<File> listFiles(File directory, String[] extensionsOrNull, boolean recursive) {
        return FileUtilities.listFiles(directory, extensionsOrNull, recursive, this.observerOrNull);
    }

    @Override
    public List<File> listFilesAndDirectories(File directory, boolean recursive) {
        return FileUtilities.listFilesAndDirectories(directory, recursive, this.observerOrNull);
    }

    @Override
    public void touch(File file) throws WrappedIOException {
        try {
            FileUtils.touch((File)file);
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    @Override
    public void deleteRecursively(File fileToRemove) throws WrappedIOException {
        boolean deleteOK = FileUtilities.deleteRecursively(fileToRemove, null, this.observerOrNull);
        if (!deleteOK) {
            throw CheckedExceptionTunnel.wrapIfNecessary(new IOException("Recursive deletion of '" + fileToRemove + "' failed."));
        }
    }

    @Override
    public boolean removeRecursively(File fileToRemove) {
        return FileUtilities.deleteRecursively(fileToRemove, null, this.observerOrNull);
    }

    @Override
    public void move(File source, File destination) throws WrappedIOException {
        if (destination.isDirectory()) {
            this.moveToDirectory(source, destination);
        } else {
            boolean renameOK = this.rename(source, destination);
            if (!renameOK) {
                throw CheckedExceptionTunnel.wrapIfNecessary(new IOException("Moving '" + source.getAbsolutePath() + "' into directory '" + destination.getAbsolutePath() + "' failed."));
            }
        }
    }

    @Override
    public void moveToDirectory(File source, File destinationDirectory) throws WrappedIOException {
        File target = new File(destinationDirectory, source.getName());
        boolean moveOK = source.renameTo(target);
        if (!moveOK) {
            throw CheckedExceptionTunnel.wrapIfNecessary(new IOException("Moving '" + source.getAbsolutePath() + "' into directory '" + destinationDirectory.getAbsolutePath() + "' failed."));
        }
    }

    @Override
    public void copyDirectory(File srcDir, File destDir) {
        try {
            FileCopyUtils.copyDirectory(srcDir, destDir, this.observerOrNull);
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    @Override
    public void copyDirectoryToDirectory(File srcDir, File destDir) throws WrappedIOException {
        try {
            FileCopyUtils.copyDirectoryToDirectory(srcDir, destDir, this.observerOrNull);
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    @Override
    public void copyFile(File srcFile, File destFile) throws WrappedIOException {
        try {
            FileCopyUtils.copyFile(srcFile, destFile);
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    @Override
    public void copyFileToDirectory(File srcFile, File destDir) throws WrappedIOException {
        try {
            FileCopyUtils.copyFileToDirectory(srcFile, destDir);
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    @Override
    public void copy(File source, File destination) throws WrappedIOException {
        try {
            FileCopyUtils.copy(source, destination);
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    @Override
    public void copyToDirectory(File source, File destDir) throws WrappedIOException {
        try {
            FileCopyUtils.copyToDirectory(source, destDir);
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    @Override
    public byte[] getContentAsByteArray(File file) throws WrappedIOException {
        byte[] byArray;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            byArray = IOUtils.toByteArray((InputStream)inputStream);
        }
        catch (IOException ex) {
            try {
                throw new WrappedIOException(ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return byArray;
    }

    @Override
    public String getContentAsString(File file) throws WrappedIOException {
        return FileUtilities.loadToString(file);
    }

    @Override
    public List<String> getContentAsStringList(File file) throws WrappedIOException {
        return FileUtilities.loadToStringList(file);
    }

    @Override
    public InputStream getInputStream(File file) throws WrappedIOException {
        return new IInputStreamAdapter(this.getIInputStream(file));
    }

    @Override
    public IInputStream getIInputStream(File file) throws WrappedIOException {
        try {
            IInputStream is = this.internalGetIInputStream(file);
            if (this.timingParametersOrNull != null) {
                return MonitoringProxy.create(IInputStream.class, is).timing(this.timingParametersOrNull).name("input stream <" + file.getAbsolutePath() + ">").get();
            }
            return is;
        }
        catch (IOException ex) {
            throw new WrappedIOException(ex);
        }
    }

    IInputStream internalGetIInputStream(File file) throws FileNotFoundException {
        return new InputStreamAdapter(new FileInputStream(file));
    }

    @Override
    public void writeToFile(File file, String content) throws WrappedIOException {
        FileUtilities.writeToFile(file, content);
    }
}

