/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.filesystem;

import ch.systemsx.cisd.common.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.WrappedIOException;
import ch.systemsx.cisd.common.filesystem.IInputStream;
import java.io.IOException;
import java.io.InputStream;

public class InputStreamAdapter
implements IInputStream {
    private final InputStream delegate;

    public InputStreamAdapter(InputStream delegate) {
        this.delegate = delegate;
    }

    public int available() throws WrappedIOException {
        try {
            return this.delegate.available();
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public void close() throws WrappedIOException {
        try {
            this.delegate.close();
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public void mark(int readlimit) {
        this.delegate.mark(readlimit);
    }

    public boolean markSupported() {
        return this.delegate.markSupported();
    }

    public int read() throws WrappedIOException {
        try {
            return this.delegate.read();
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public int read(byte[] b, int off, int len) throws WrappedIOException {
        try {
            return this.delegate.read(b, off, len);
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public int read(byte[] b) throws WrappedIOException {
        try {
            return this.delegate.read(b);
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public void reset() throws WrappedIOException {
        try {
            this.delegate.reset();
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public long skip(long n) throws WrappedIOException {
        try {
            return this.delegate.skip(n);
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }
}

