/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.test;

import org.testng.AssertJUnit;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EqualsHashCodeTestCase<T> {
    private T eq1;
    private T eq2;
    private T eq3;
    private T neq;
    private static final int NUM_ITERATIONS = 20;

    protected abstract T createInstance() throws Exception;

    protected abstract T createNotEqualInstance() throws Exception;

    @BeforeClass
    public final void setUp() throws Exception {
        this.eq1 = this.createInstance();
        this.eq2 = this.createInstance();
        this.eq3 = this.createInstance();
        this.neq = this.createNotEqualInstance();
        assert (this.eq1 != null) : "createInstance() returned null";
        assert (this.eq2 != null) : "2nd createInstance() returned null";
        assert (this.eq3 != null) : "3rd createInstance() returned null";
        assert (this.neq != null) : "createNotEqualInstance() returned null";
        AssertJUnit.assertNotSame(this.eq1, this.eq2);
        AssertJUnit.assertNotSame(this.eq1, this.eq3);
        AssertJUnit.assertNotSame(this.eq1, this.neq);
        AssertJUnit.assertNotSame(this.eq2, this.eq3);
        AssertJUnit.assertNotSame(this.eq2, this.neq);
        AssertJUnit.assertNotSame(this.eq3, this.neq);
        assert (this.eq1.getClass().equals(this.eq2.getClass())) : "1st and 2nd equal instances of different classes";
        assert (this.eq1.getClass().equals(this.eq3.getClass())) : "1st and 3nd equal instances of different classes";
        assert (this.eq1.getClass().equals(this.neq.getClass())) : "1st equal instance and not-equal instance of different classes";
    }

    @Test
    public final void testEqualsAgainstNewObject() {
        Object o = new Object();
        AssertJUnit.assertNotSame(this.eq1, (Object)o);
        AssertJUnit.assertNotSame(this.eq2, (Object)o);
        AssertJUnit.assertNotSame(this.eq3, (Object)o);
        AssertJUnit.assertNotSame(this.neq, (Object)o);
    }

    @Test
    public final void testEqualsAgainstNull() {
        AssertJUnit.assertNotSame((String)"1st vs. null", this.eq1, null);
        AssertJUnit.assertNotSame((String)"2nd vs. null", this.eq2, null);
        AssertJUnit.assertNotSame((String)"3rd vs. null", this.eq3, null);
        AssertJUnit.assertNotSame((String)"not-equal vs. null", this.neq, null);
    }

    @Test
    public final void testEqualsAgainstUnequalObjects() {
        assert (!this.eq1.equals(this.neq)) : "1st vs. not-equal";
        assert (!this.eq2.equals(this.neq)) : "2nd vs. not-equal";
        assert (!this.eq3.equals(this.neq)) : "3rd vs. not-equal";
        assert (!this.neq.equals(this.eq1)) : "not-equal vs. 1st";
        assert (!this.neq.equals(this.eq2)) : "not-equal vs. 2nd";
        assert (!this.neq.equals(this.eq3)) : "not-equal vs. 3rd";
    }

    @Test
    public final void testEqualsIsConsistentAcrossInvocations() {
        int i = 0;
        while (i < 20) {
            this.testEqualsAgainstNewObject();
            this.testEqualsAgainstNull();
            this.testEqualsAgainstUnequalObjects();
            this.testEqualsIsReflexive();
            this.testEqualsIsSymmetricAndTransitive();
            ++i;
        }
    }

    @Test
    public final void testEqualsIsReflexive() {
        assert (this.eq1.equals(this.eq1)) : "1st equal instance";
        assert (this.eq2.equals(this.eq2)) : "2nd equal instance";
        assert (this.eq3.equals(this.eq3)) : "3rd equal instance";
        assert (this.neq.equals(this.neq)) : "not-equal equal instance";
    }

    @Test
    public final void testEqualsIsSymmetricAndTransitive() {
        assert (this.eq1.equals(this.eq2)) : "1st vs. 2nd";
        assert (this.eq2.equals(this.eq1)) : "2nd vs. 1st";
        assert (this.eq1.equals(this.eq3)) : "1st vs. 3rd";
        assert (this.eq3.equals(this.eq1)) : "3rd vs. 1st";
        assert (this.eq2.equals(this.eq3)) : "2nd vs. 3rd";
        assert (this.eq3.equals(this.eq2)) : "3rd vs. 2nd";
    }

    @Test
    public final void testHashCodeContract() {
        assert (this.eq1.hashCode() == this.eq2.hashCode()) : "1st vs. 2nd";
        assert (this.eq1.hashCode() == this.eq3.hashCode()) : "1st vs. 3rd";
        assert (this.eq2.hashCode() == this.eq3.hashCode()) : "2nd vs. 3rd";
    }

    @Test
    public final void testHashCodeIsConsistentAcrossInvocations() {
        int eq1Hash = this.eq1.hashCode();
        int eq2Hash = this.eq2.hashCode();
        int eq3Hash = this.eq3.hashCode();
        int neqHash = this.neq.hashCode();
        int i = 0;
        while (i < 20) {
            assert (eq1Hash == this.eq1.hashCode()) : "1st equal instance";
            assert (eq2Hash == this.eq2.hashCode()) : "2nd equal instance";
            assert (eq3Hash == this.eq3.hashCode()) : "3rd equal instance";
            assert (neqHash == this.neq.hashCode()) : "not-equal instance";
            ++i;
        }
    }
}

